using namespace std;
#include <iostream>
#include <stdlib.h>
#include <fstream>
#include <sstream>
#include <math.h>

#include <GL/glut.h>
#include <math.h>
#include <string.h>
#include <tbgl/tb.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mcg.h>

#include <vector>
#include "OutilsPPM.h"

class obj;
	

	int win_x, win_y;
int largeurF, hauteurF;
double zoom;
bool AFF;
int obj_encours = 0;
int nbrMaillage;

uint listeGL[20];
GLfloat mat_amb[] = { 0.2, 0.2, 0.2, 1.0 };
GLfloat mat_dif[] = { 0.7, 0.5, 0.5, 1.0 };
GLfloat mat_spe[] = { 0.2, 0.2, 0.0, 1.0 };

typedef struct
{
	float x,y,z;
} pt;

class obj
{
	public:
		std::vector<pt> point;
		std::vector<pt> normale;
		std::vector< vector<unsigned int> >  face;
	
	public:
		obj ();
		~obj ();
		
		bool charger (const char *fichier);
		void normaliser ();
};


obj::obj ()
{
}


obj::~obj ()
{
}


bool obj::charger (const char *fichier)
{
	pt tmp;
	int idPoint, cpt;
	ifstream fichierOBJ(fichier, ios::in);
	
	
	if (!fichierOBJ.is_open())
	{
		cout << "[-] obj::charger > Impossible d'ouvrir le fichier " << fichier << endl;
		return false;
	}
	
	
	
	while(!fichierOBJ.eof())
	{
		string line;
		istringstream iss;
		string keyword;
		
		// lecture d'une ligne et construction du flot de parsing
		getline(fichierOBJ, line);
		iss.str(line);
		
		// si le premier caractere est un #, alors c'est une ligne de commentaire
		if(iss.peek() != '#')
		{
			// recuperation du mot-cle
			iss >> keyword;
			
			if (keyword == "v") /* point */
			{
				iss >> tmp.x >> tmp.y >> tmp.z;
				tmp.z = -tmp.z;
				point.push_back(tmp);
			}
			else if (keyword == "vn") /* normale */
			{
				iss >> tmp.x >> tmp.y >> tmp.z;
				tmp.x = 0;
				tmp.y = 0;
				tmp.z = 0;
				normale.push_back(tmp);
			}
			else if (keyword == "f") /* face */
			{
				vector<uint> enCours;		// face en cours
				
				cpt = 0;
				/* tant que tout est ok, on lit l'indice du sommet */
				while(iss.good())
				{
					iss >> idPoint;
					enCours.push_back (idPoint-1);
					cpt++;
				}
				
				if (cpt < 3)
				{
					cout << "[-] obj::charger > Une des faces possde moins de 3 sommets.\n";
					return false;
				}
				
				face.push_back(enCours);
			}
		}
	}
	cout << "lecture ok\n";
	return true;
}







void obj::normaliser()
{
	vector<uint> enCours;
	int indiceP1, indiceP2, indiceN;
	pt p1, p2, n;
	double dist;
	
	for (unsigned int i=0; i!=normale.size(); i++)
		normale.at(i).x = normale.at(i).y = normale.at(i).y = 0;
	
	
	for (unsigned int i=0; i!=face.size(); i++)
	{
		enCours = face.at(i);
		n.x = n.y = n.z = 0;
		
		for (unsigned int j=0; j!=enCours.size(); j++)
		{
			if (j==0)
				indiceP1 = enCours.at(enCours.size()-1);
			else
				indiceP1 = enCours.at(j-1);
			
			indiceP2 = enCours.at(j);
			
			p1 = point.at(indiceP1);
			p2 = point.at(indiceP2);
			// calcul de la normale
			n.x += (p1.z + p2.z) * (p1.y - p2.y);
			n.y += (p1.x + p2.x) * (p1.z - p2.z);
			n.z += (p1.y + p2.y) * (p1.x - p2.x);
		}
		
		// normalisation et affectation
		dist = sqrt(n.x*n.x + n.y*n.y + n.z*n.z);
		if (dist > 0.0000001)
		{
			n.x /= dist;
			n.y /= dist;
			n.z /= dist;
		}
		
		for (unsigned int j=0; j!=enCours.size(); j++)
		{
			indiceN = enCours.at(j);
			normale.at(indiceN).x += n.x;
			normale.at(indiceN).y += n.y;
			normale.at(indiceN).z += n.z;
		}
	}
	
	
	for (unsigned int i=0; i!=normale.size(); i++)
	{
		// normalisation et affectation
		dist = sqrt(normale.at(i).x*normale.at(i).x + normale.at(i).y*normale.at(i).y + normale.at(i).z*normale.at(i).z);
		if (dist > 0.0000001)
		{
			normale.at(i).x /= dist;
			normale.at(i).y /= dist;
			normale.at(i).z /= dist;
		}
	}
}
























void timer (int value)
{
	if (value == 0)
	{/*
		Image tmp;
		char nomImg[255];
		CreerImage(&tmp,largeurF,hauteurF);
		glReadPixels(0,0,largeurF,hauteurF,GL_RGB, GL_UNSIGNED_BYTE,tmp.data);
		inverserImage(&tmp);
		sprintf(nomImg,"export/%06d.ppm",obj_encours);
		EcrireImage(nomImg,&tmp);
		LibererImage(&tmp);
		*/
		obj_encours++;
		glutPostRedisplay();
	}
	
}

void affichageGL()
{	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 1.0, zoom, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	
	glPushMatrix();
		tbMatrix();
		
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,   mat_amb);
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,   mat_dif);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  mat_spe);
		glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, 0);
		
		if (listeGL[obj_encours%nbrMaillage] != 0)
			glCallList(listeGL[obj_encours%nbrMaillage]);
		
		glPopMatrix();
	glutSwapBuffers();
	
	if (AFF)
		glutTimerFunc(1000 / 20, timer, 0);
}


void redimGL(int _w, int _h)
{
	tbReshape(_w, _h);

	largeurF = _w;
	hauteurF = _h;
	glViewport(0, 0, _w, _h);
	
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60, (GLfloat)_w/(GLfloat)_h, 0.1, 128.0);
		
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 1.0, zoom, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
}


void clavierGL(unsigned char _k, int _x, int _y)
{
	switch(_k)
	{
		case '+' :
			obj_encours++;
			break;
		
		case '-' :
			obj_encours--;
			break;
		
		case ' ':
			AFF = !AFF;
			break;
		
		case 27 : 
			exit(0);
			break;
	}

	glutPostRedisplay();	
}


void clavierSpecialGL(int _k, int _x, int _y)
{
	switch(_k)
	{	
		case GLUT_KEY_PAGE_UP : 
			zoom += 0.1;
			break;
			
		case GLUT_KEY_PAGE_DOWN :	
			if(zoom > 0.1)
				zoom -= 0.1;
			break;		
	}

	glutPostRedisplay();
}


void sourisGL(int _b, int _s, int _x, int _y)
{
	tbMouse(_b, _s, _x, _y);
	glutPostRedisplay();
}


void deplacementGL(int _x, int _y)
{
	tbMotion(_x, _y);
	glutPostRedisplay();
}


void initGL()
{
	GLfloat specular[] 	= { 0.5, 0.5, 0.5, 1.0 };
	GLfloat ambient [] 	= { 0.3, 0.3, 0.3      };
	GLfloat position[] 	= { 0.0, 0.0, 2.0, 1.0 };
	
	glClearColor(0.5, 0.5, 0.5, 1.0);

	glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
	glLightfv(GL_LIGHT0, GL_POSITION, position);
	glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);

	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	
	tbInit(GLUT_LEFT_BUTTON);
	tbAnimate(GL_TRUE);
	
	zoom = 2;
}


uint creerListeGL (obj *fichierObj)
{
	int ptCourant;
	pt tmp;
	vector<uint> enCours;
	
	uint glList = glGenLists(1);
	glNewList(glList, GL_COMPILE);
		if (fichierObj)
		{
			for (unsigned int i=0; i!=fichierObj->face.size(); i++)
			{
				enCours = fichierObj->face.at(i);
				
				glBegin(GL_POLYGON);
				for (unsigned int j=0; j!=enCours.size(); j++)
				{
					ptCourant = enCours.at(j);
					
					tmp = fichierObj->normale.at(ptCourant);
					glNormal3f(tmp.x, tmp.y, tmp.z);
					
					tmp = fichierObj->point.at(ptCourant);
					glVertex3f(tmp.x, tmp.y, tmp.z);
				}
				glEnd();
			}
		}	
	glEndList();
	
	return glList;
}


int main(int _argc, char ** _argv)
{
	glutInit(&_argc, _argv);
	
	AFF = false;
	for (int i=0; i!=20; i++)
		listeGL[i] = 0;
	
	largeurF = 800;
	hauteurF = 600;
	
	win_x = 150; //(glutGet(GLUT_SCREEN_WIDTH)  - largeurF)/2;
	win_y = 150; //(glutGet(GLUT_SCREEN_HEIGHT) - hauteurF)/2;
	
	glutInitWindowSize(largeurF, hauteurF);
	glutInitWindowPosition(win_x, win_y);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	glutCreateWindow("coeur qui bouge :p");

	glutDisplayFunc(affichageGL);
	glutReshapeFunc(redimGL);

	glutKeyboardFunc(clavierGL);
	glutSpecialFunc(clavierSpecialGL);
	glutMouseFunc(sourisGL);
	glutMotionFunc(deplacementGL);

	initGL();
	
	nbrMaillage = 20;
	obj *fichierObj;
	char tmp[255];
	for (int i=0; i<nbrMaillage; i++)
	{
		sprintf(tmp,"./data/coeur_t%d.1.obj",i+1);
		fichierObj = new obj();
		fichierObj->charger(tmp);
		fichierObj->normaliser();
		listeGL[i] = creerListeGL(fichierObj);
		delete fichierObj;
	}
	
	glutMainLoop();
	return 0;
}
