#include <algebre.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


void pz2_zero(pz2 _a)
{
	_a[0] = 0;
	_a[1] = 0;
}


void pz2_affecter(pz2 _a, int _x, int _y)
{
	_a[0] = _x;
	_a[1] = _y;
}


void pz2_copier(pz2 _a, pz2 _b)
{
	_b[0] = _a[0];
	_b[1] = _a[1];
}


void pz2_ajouter(pz2 _a, pz2 _b, pz2 _c)
{
	_c[0] = _a[0] + _b[0];
	_c[1] = _a[1] + _b[1];
}


void pz2_soustraire(pz2 _a, pz2 _b, pz2 _c)
{
	_c[0] = _a[0] - _b[0];
	_c[1] = _a[1] - _b[1];
}


void pz2_multiplier(pz2 _a, pz2 _b, pz2 _c)
{
	_c[0] = _a[0] * _b[0];
	_c[1] = _a[1] * _b[1];
}


void pz2_diviser(pz2 _a, pz2 _b, pz2 _c)
{
	_c[0] = _a[0] / _b[0];
	_c[1] = _a[1] / _b[1];
}


void pz2_inverser(pz2 _a, pz2 _b)
{
	_b[0] = -_a[0];
	_b[1] = -_a[1];
}


void pz2_ajouter_coeff(pz2 _a, int _b, pz2 _c)
{
	_c[0] = _a[0] + _b;
	_c[1] = _a[1] + _b;
}


void pz2_multiplier_coeff(pz2 _a, int _b, pz2 _c)
{
	_c[0] = _a[0] * _b;
	_c[1] = _a[1] * _b;
}


double pz2_norme(pz2 _a)
{
	return sqrt(_a[0] * _a[0] + _a[1] * _a[1]);
}


void pz2_normaliser(pz2 _a)
{
	double n;
	
	n = pz2_norme(_a);
	if(n > 0.000001)
	{
		_a[0] /= (int)n;
		_a[1] /= (int)n;
	}
}


int pz2_scalaire(pz2 _a, pz2 _b)
{
	return _a[0] * _b[0] + _a[1] * _b[1];
}


int pz2_egaux(pz2 _a, pz2 _b)
{
	return _a[0] == _b[0] && _a[1] == _b[1];
}


void pr2_zero(pr2 _a)
{
	_a[0] = 0.0;
	_a[1] = 0.0;
}


void pr2_affecter(pr2 _a, double _x, double _y)
{
	_a[0] = _x;
	_a[1] = _y;
}


void pr2_copier(pr2 _a, pr2 _b)
{
	_b[0] = _a[0];
	_b[1] = _a[1];
}


void pr2_ajouter(pr2 _a, pr2 _b, pr2 _c)
{
	_c[0] = _a[0] + _b[0];
	_c[1] = _a[1] + _b[1];
}


void pr2_soustraire(pr2 _a, pr2 _b, pr2 _c)
{
	_c[0] = _a[0] - _b[0];
	_c[1] = _a[1] - _b[1];
}


void pr2_multiplier(pr2 _a, pr2 _b, pr2 _c)
{
	_c[0] = _a[0] * _b[0];
	_c[1] = _a[1] * _b[1];
}


void pr2_diviser(pr2 _a, pr2 _b, pr2 _c)
{
	_c[0] = _a[0] / _b[0];
	_c[1] = _a[1] / _b[1];
}


void pr2_inverser(pr2 _a, pr2 _b)
{
	_b[0] = -_a[0];
	_b[1] = -_a[1];
}


void pr2_ajouter_coeff(pr2 _a, double _b, pr2 _c)
{
	_c[0] = _a[0] + _b;
	_c[1] = _a[1] + _b;
}


void pr2_multiplier_coeff(pr2 _a, double _b, pr2 _c)
{
	_c[0] = _a[0] * _b;
	_c[1] = _a[1] * _b;
}


double pr2_norme(pr2 _a)
{
	return sqrt(_a[0] * _a[0] + _a[1] * _a[1]);
}


void pr2_normaliser(pr2 _a)
{
	double n;
	
	n = pr2_norme(_a);	
	if(n > 0.000001)
	{
		_a[0] /= n;
		_a[1] /= n;
	}
}


double pr2_scalaire(pr2 _a, pr2 _b)
{
	return _a[0] * _b[0] + _a[1] * _b[1];
}


int pr2_egaux(pr2 _a, pr2 _b)
{
	return _a[0] == _b[0] && _a[1] == _b[1];
}


void pz3_zero(pz3 _a)
{
	_a[0] = 0;
	_a[1] = 0;
	_a[2] = 0;
}


void pz3_affecter(pz3 _a, int _x, int _y, int _z)
{
	_a[0] = _x;
	_a[1] = _y;
	_a[2] = _z;
}


void pz3_copier(pz3 _a, pz3 _b)
{
	_b[0] = _a[0];
	_b[1] = _a[1];
	_b[2] = _a[2];
}


void pz3_ajouter(pz3 _a, pz3 _b, pz3 _c)
{
	_c[0] = _a[0] + _b[0];
	_c[1] = _a[1] + _b[1];
	_c[2] = _a[2] + _b[2];
}


void pz3_soustraire(pz3 _a, pz3 _b, pz3 _c)
{
	_c[0] = _a[0] - _b[0];
	_c[1] = _a[1] - _b[1];
	_c[2] = _a[2] - _b[2];
}


void pz3_multiplier(pz3 _a, pz3 _b, pz3 _c)
{
	_c[0] = _a[0] * _b[0];
	_c[1] = _a[1] * _b[1];
	_c[2] = _a[2] * _b[2];
}


void pz3_diviser(pz3 _a, pz3 _b, pz3 _c)
{
	_c[0] = _a[0] / _b[0];
	_c[1] = _a[1] / _b[1];
	_c[2] = _a[2] / _b[2];
}


void pz3_inverser(pz3 _a, pz3 _b)
{
	_b[0] = -_a[0];
	_b[1] = -_a[1];
	_b[2] = -_a[2];
}


void pz3_ajouter_coeff(pz3 _a, int _b, pz3 _c)
{
	_c[0] = _a[0] + _b;
	_c[1] = _a[1] + _b;
	_c[2] = _a[2] + _b;
}


void pz3_multiplier_coeff(pz3 _a, int _b, pz3 _c)
{
	_c[0] = _a[0] * _b;
	_c[1] = _a[1] * _b;
	_c[2] = _a[2] * _b;
}


double pz3_norme(pz3 _a)
{
	return sqrt(_a[0] * _a[0] + _a[1] * _a[1] + _a[2] * _a[2]); 
}


void pz3_normaliser(pz3 _a)
{
	double n;
	
	n = pz3_norme(_a);	
	if(n > 0.000001)
	{
		_a[0] /= (int)n;
		_a[1] /= (int)n;
		_a[2] /= (int)n;
	}
}


int pz3_scalaire(pz3 _a, pz3 _b)
{
	return _a[0] * _b[0] + _a[1] * _b[1] + _a[2] * _b[2];
}


void pz3_vectoriel(pz3 _a, pz3 _b, pz3 _c)
{
	_c[0] = _a[1] * _b[2] - _a[2] * _b[1];
	_c[1] = _a[2] * _b[0] - _a[0] * _b[2];
	_c[2] = _a[0] * _b[1] - _a[1] * _b[0];
}


int pz3_egaux(pz3 _a, pz3 _b)
{
	return _a[0] == _b[0] && _a[1] == _b[1] && _a[2] == _b[2];
}


void pr3_zero(pr3 _a)
{
	_a[0] = 0.0;
	_a[1] = 0.0;
	_a[2] = 0.0;
}


void pr3_affecter(pr3 _a, double _x, double _y, double _z)
{
	_a[0] = _x;
	_a[1] = _y;
	_a[2] = _z;
}


void pr3_copier(pr3 _a, pr3 _b)
{
	_b[0] = _a[0];
	_b[1] = _a[1];
	_b[2] = _a[2];
}


void pr3_ajouter(pr3 _a, pr3 _b, pr3 _c)
{
	_c[0] = _a[0] + _b[0];
	_c[1] = _a[1] + _b[1];
	_c[2] = _a[2] + _b[2];
}


void pr3_soustraire(pr3 _a, pr3 _b, pr3 _c)
{
	_c[0] = _a[0] - _b[0];
	_c[1] = _a[1] - _b[1];
	_c[2] = _a[2] - _b[2];
}


void pr3_multiplier(pr3 _a, pr3 _b, pr3 _c)
{
	_c[0] = _a[0] * _b[0];
	_c[1] = _a[1] * _b[1];
	_c[2] = _a[2] * _b[2];
}


void pr3_diviser(pr3 _a, pr3 _b, pr3 _c)
{
	_c[0] = _a[0] / _b[0];
	_c[1] = _a[1] / _b[1];
	_c[2] = _a[2] / _b[2];
}


void pr3_inverser(pr3 _a, pr3 _b)
{
	_b[0] = -_a[0];
	_b[1] = -_a[1];
	_b[2] = -_a[2];
}


void pr3_ajouter_coeff(pr3 _a, double _b, pr3 _c)
{
	_c[0] = _a[0] + _b;
	_c[1] = _a[1] + _b;
	_c[2] = _a[2] + _b;
}


void pr3_multiplier_coeff(pr3 _a, double _b, pr3 _c)
{
	_c[0] = _a[0] * _b;
	_c[1] = _a[1] * _b;
	_c[2] = _a[2] * _b;
}


double pr3_norme(pr3 _a)
{
	return sqrt(_a[0] * _a[0] + _a[1] * _a[1] + _a[2] * _a[2]); 
}


void pr3_normaliser(pr3 _a)
{
	double n;
	
	n = pr3_norme(_a);	
	if(n > 0.000001)
	{
		_a[0] /= n;
		_a[1] /= n;
		_a[2] /= n;
	}
}


double pr3_scalaire(pr3 _a, pr3 _b)
{
	return _a[0] * _b[0] + _a[1] * _b[1] + _a[2] * _b[2];
}


void pr3_vectoriel(pr3 _a, pr3 _b, pr3 _c)
{
	_c[0] = _a[1] * _b[2] - _a[2] * _b[1];
	_c[1] = _a[2] * _b[0] - _a[0] * _b[2];
	_c[2] = _a[0] * _b[1] - _a[1] * _b[0];
}


int pr3_egaux(pr3 _a, pr3 _b)
{
	return _a[0] == _b[0] && _a[1] == _b[1] && _a[2] == _b[2];
}


void m44_zero(m44 _m)
{
	int i;
	
	for(i = 0; i < 16; i++)
		*(_m[0] + i) = 0;
}


void m44_identite(m44 _m)
{
	m44_zero(_m);
		
	_m[0][0] = 1;
	_m[1][1] = 1;
	_m[2][2] = 1;
	_m[3][3] = 1;
}


void m44_transpose(m44 _m, m44 _n)
{
	_n[0][0] = _m[0][0];
	_n[0][1] = _m[1][0];
	_n[0][2] = _m[2][0];
	_n[0][3] = _m[3][0];
		              
	_n[1][0] = _m[0][1];
	_n[1][1] = _m[1][1];
	_n[1][2] = _m[2][1];
	_n[1][3] = _m[3][1];
	                 
	_n[2][0] = _m[0][2];
	_n[2][1] = _m[1][2];
	_n[2][2] = _m[2][2];
	_n[2][3] = _m[3][2];
	                 
	_n[3][0] = _m[0][3];
	_n[3][1] = _m[1][3];
	_n[3][2] = _m[2][3];
	_n[3][3] = _m[3][3];	
}


void m44_multiplier(m44 _m, pr3 _p, pr4 _q)
{
	_q[0] = _p[0] * _m[0][0] + _p[1] * _m[1][0] + _p[2] * _m[2][0] + _m[3][0];
	_q[1] = _p[0] * _m[0][1] + _p[1] * _m[1][1] + _p[2] * _m[2][1] + _m[3][1];
	_q[2] = _p[0] * _m[0][2] + _p[1] * _m[1][2] + _p[2] * _m[2][2] + _m[3][2];
	_q[3] = _p[0] * _m[0][3] + _p[1] * _m[1][3] + _p[2] * _m[2][3] + _m[3][3];
}


void m44_produit(m44 _a, m44 _b, m44 _c)
{	
	_c[0][0] = _a[0][0] * _b[0][0] + _a[0][1] * _b[1][0] + _a[0][2] * _b[2][0] + _a[0][3] * _b[3][0];
	_c[0][1] = _a[0][0] * _b[0][1] + _a[0][1] * _b[1][1] + _a[0][2] * _b[2][1] + _a[0][3] * _b[3][1];
	_c[0][2] = _a[0][0] * _b[0][2] + _a[0][1] * _b[1][2] + _a[0][2] * _b[2][2] + _a[0][3] * _b[3][2];
	_c[0][3] = _a[0][0] * _b[0][3] + _a[0][1] * _b[1][3] + _a[0][2] * _b[2][3] + _a[0][3] * _b[3][3];
		
	_c[1][0] = _a[1][0] * _b[0][0] + _a[1][1] * _b[1][0] + _a[1][2] * _b[2][0] + _a[1][3] * _b[3][0];
	_c[1][1] = _a[1][0] * _b[0][1] + _a[1][1] * _b[1][1] + _a[1][2] * _b[2][1] + _a[1][3] * _b[3][1];
	_c[1][2] = _a[1][0] * _b[0][2] + _a[1][1] * _b[1][2] + _a[1][2] * _b[2][2] + _a[1][3] * _b[3][2];
	_c[1][3] = _a[1][0] * _b[0][3] + _a[1][1] * _b[1][3] + _a[1][2] * _b[2][3] + _a[1][3] * _b[3][3];
	
	_c[2][0] = _a[2][0] * _b[0][0] + _a[2][1] * _b[1][0] + _a[2][2] * _b[2][0] + _a[2][3] * _b[3][0];
	_c[2][1] = _a[2][0] * _b[0][1] + _a[2][1] * _b[1][1] + _a[2][2] * _b[2][1] + _a[2][3] * _b[3][1];
	_c[2][2] = _a[2][0] * _b[0][2] + _a[2][1] * _b[1][2] + _a[2][2] * _b[2][2] + _a[2][3] * _b[3][2];
	_c[2][3] = _a[2][0] * _b[0][3] + _a[2][1] * _b[1][3] + _a[2][2] * _b[2][3] + _a[2][3] * _b[3][3];
	
	_c[3][0] = _a[3][0] * _b[0][0] + _a[3][1] * _b[1][0] + _a[3][2] * _b[2][0] + _a[3][3] * _b[3][0];
	_c[3][1] = _a[3][0] * _b[0][1] + _a[3][1] * _b[1][1] + _a[3][2] * _b[2][1] + _a[3][3] * _b[3][1];
	_c[3][2] = _a[3][0] * _b[0][2] + _a[3][1] * _b[1][2] + _a[3][2] * _b[2][2] + _a[3][3] * _b[3][2];
	_c[3][3] = _a[3][0] * _b[0][3] + _a[3][1] * _b[1][3] + _a[3][2] * _b[2][3] + _a[3][3] * _b[3][3];	
}
