#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "OutilsPPM.h"

int CreerImage(Image *image, int largeur, int hauteur)
{
    image->width=largeur;
    image->height=hauteur;
    image->size=image->width*image->height;
    image->data=(Pixel*)malloc(3*image->size*sizeof(Pixel));
    
    if (image->data == NULL)
       {
       printf ("ERREUR malloc (%d)\n", image->size * 3 * sizeof(Pixel));
       return -1;
       }
    return 0;
}
    

int LireImage(char *nom, Image *image)
{
    FILE *f;
    char s[MAXLIGNE];
    int width, height, maxcolor, n, k;
    unsigned char ligne[10240];
    
    /* Ouverture du fichier */
    f = fopen (nom, "rb");
    if (f == NULL)
       {
       printf ("ERREUR fopen(%s)\n", nom);
       return -1;
       }
    /* Lecture MagicValue
    * On evite fscanf pour eviter buffer overflow */
    
    fgets (s, MAXLIGNE, f);
    if (s[0] != 'P' || s[1] != '6')
       {
       printf ("ERREUR MagicValue <> P3\n");
       fclose (f);
       return -1;
       }
    
    /* Lecture width height
    * On saute les ligne commencant par un '#' */
    do fgets (s, MAXLIGNE, f);
    while (s[0] == '#');
    sscanf (s, "%d %d", &width, &height);
 
    /* Lecture maxgrey
    * On ne tient pas compte de maxcolors, qui est presque toujours 255.
    * On saute les ligne commenant par un '#' */
    
    do fgets (s, MAXLIGNE, f);
    while (s[0] == '#');
    sscanf (s, "%d", &maxcolor);
    /* Allocation Image */
    if (CreerImage (image, width, height) < 0)
       {
       fclose (f);
       return -1;
       }
    /* Lecture image et inversion des lignes */
    for (n=0;n<image->height;n++)
        {
        if (fread(ligne,sizeof(unsigned char)*image->width*3,1,f)!=1)
           return -1; /* Erreur de lecture */
        for (k=0;k<image->width*3;k++)
            image->data[(image->height-1-n)*width*3+k]=(Pixel)ligne[k];
        }
    fclose (f);
    return 0;
}

int EcrireImage(char *nom, Image *image) 
{
    FILE *fp;
    
    fp = fopen(nom,"wb");
    if ((void *) fp == NULL ) return(-1);
    fprintf(fp,"P6\n%d %d\n255\n",image->width,image->height);
    fwrite(image->data, 3, image->width*image->height,fp);
    fclose(fp);
    return(0);
}

void inverserImage(Image *t)
{
	int i,j;
	unsigned char *data, *tmp;
	data = (Pixel*)malloc(3*t->size*sizeof(Pixel));
	
	for (i=0;i!=t->width;i++)
	{
		for (j=0;j!=t->height;j++)
		{
			data[((t->width - i - 1)*t->width + j)*3 + 0] = t->data[(i*t->width + j)*3 + 0];
			data[((t->width - i - 1)*t->width + j)*3 + 1] = t->data[(i*t->width + j)*3 + 1];
			data[((t->width - i - 1)*t->width + j)*3 + 2] = t->data[(i*t->width + j)*3 + 2];
		}
	}
	
	tmp = t->data;
	t->data = data;
	
	free(tmp);
}

	
void LibererImage(Image *i)
{
    if (i->data != NULL)
	free(i->data);
    
    i->data = NULL;
}
