#ifndef __algebre__
#define __algebre__


typedef int		pz2[2];		/* Definition du type point 2D a coordonnees entieres 	*/
typedef double	pr2[2];		/* Definition du type point 2D a coordonnees reelles 	*/

typedef int		pz3[3];		/* Definition du type point 3D a coordonnees entieres 	*/
typedef double	pr3[3];		/* Definition du type point 3D a coordonnees reelles 	*/

typedef double	pr4[4];		/* Definition du type point 3D a coordonnees homogenes	*/

typedef double	m44[4][4];	/* Definition du type matrice 4D a coefficients reels 	*/


void	pz2_zero			(pz2 _a);								/* a = (0, 0) 		*/
void	pz2_affecter		(pz2 _a, int _x, int _y);				/* a = (x, y) 		*/
void	pz2_copier			(pz2 _a, pz2 _b);						/* b = a 	  		*/

void	pz2_ajouter			(pz2 _a, pz2 _b, pz2 _c);				/* c = a + b 		*/
void	pz2_soustraire		(pz2 _a, pz2 _b, pz2 _c);				/* c = a - b 		*/
void	pz2_multiplier		(pz2 _a, pz2 _b, pz2 _c);				/* c = a * b 		*/
void	pz2_diviser			(pz2 _a, pz2 _b, pz2 _c);				/* c = a / b 		*/
void	pz2_inverser		(pz2 _a, pz2 _b);						/* b = -a	 		*/

void	pz2_ajouter_coeff	(pz2 _a, int _b, pz2 _c);				/* c = a + b 		*/
void	pz2_multiplier_coeff(pz2 _a, int _b, pz2 _c);				/* c = a * b 		*/

double	pz2_norme			(pz2 _a);								/* r : ||a|| 		*/
void	pz2_normaliser		(pz2 _a);								/* a = a / ||a||	*/
int		pz2_scalaire		(pz2 _a, pz2 _b);						/* r : a . c		*/

int		pz2_egaux			(pz2 _a, pz2 _b);						/* 1 si a == b 		*/


void	pr2_zero			(pr2 _a);
void	pr2_affecter		(pr2 _a, double _x, double _y);
void	pr2_copier			(pr2 _a, pr2 _b);

void	pr2_ajouter			(pr2 _a, pr2 _b, pr2 _c);
void	pr2_soustraire		(pr2 _a, pr2 _b, pr2 _c);
void	pr2_multiplier		(pr2 _a, pr2 _b, pr2 _c);
void	pr2_diviser			(pr2 _a, pr2 _b, pr2 _c);
void	pr2_inverser		(pr2 _a, pr2 _b);

void	pr2_ajouter_coeff	(pr2 _a, double _b, pr2 _c);
void	pr2_multiplier_coeff(pr2 _a, double _b, pr2 _c);

double	pr2_norme			(pr2 _a);
void	pr2_normaliser		(pr2 _a);
double	pr2_scalaire		(pr2 _a, pr2 _b);

int		pr2_egaux			(pr2 _a, pr2 _b);


void	pz3_zero			(pz3 _a);
void	pz3_affecter		(pz3 _a, int _x, int _y, int _z);
void	pz3_copier			(pz3 _a, pz3 _b);

void	pz3_ajouter			(pz3 _a, pz3 _b, pz3 _c);
void	pz3_soustraire		(pz3 _a, pz3 _b, pz3 _c);
void	pz3_multiplier		(pz3 _a, pz3 _b, pz3 _c);
void	pz3_diviser			(pz3 _a, pz3 _b, pz3 _c);
void	pz3_inverser		(pz3 _a, pz3 _b);

void	pz3_ajouter_coeff	(pz3 _a, int _b, pz3 _c);
void	pz3_multiplier_coeff(pz3 _a, int _b, pz3 _c);

double	pz3_norme			(pz3 _a);
void	pz3_normaliser		(pz3 _a);
int		pz3_scalaire		(pz3 _a, pz3 _b);
void	pz3_vectoriel		(pz3 _a, pz3 _b, pz3 _c);				/*	c = a ^ b		*/

int		pz3_egaux			(pz3 _a, pz3 _b);


void	pr3_zero			(pr3 _a);
void	pr3_affecter		(pr3 _a, double _x, double _y, double _z);
void	pr3_copier			(pr3 _a, pr3 _b);

void	pr3_ajouter			(pr3 _a, pr3 _b, pr3 _c);
void	pr3_soustraire		(pr3 _a, pr3 _b, pr3 _c);
void	pr3_multiplier		(pr3 _a, pr3 _b, pr3 _c);
void	pr3_diviser			(pr3 _a, pr3 _b, pr3 _c);
void	pr3_inverser		(pr3 _a, pr3 _b);

void	pr3_ajouter_coeff	(pr3 _a, double _b, pr3 _c);
void	pr3_multiplier_coeff(pr3 _a, double _b, pr3 _c);

double	pr3_norme			(pr3 _a);
void	pr3_normaliser		(pr3 _a);
double	pr3_scalaire		(pr3 _a, pr3 _b);
void	pr3_vectoriel		(pr3 _a, pr3 _b, pr3 _c);

int		pr3_egaux			(pr3 _a, pr3 _b);


void 	m44_zero			(m44 _m);
void 	m44_identite		(m44 _m);

void 	m44_transpose		(m44 _m, m44 _n);

void	m44_multiplier		(m44 _m, pr3 _p, pr4 _c);
void	m44_produit			(m44 _a, m44 _b, m44 _c);


#endif
