#include "volume.h"
#include "algebre.h"
#include "liste.h"


#include <GL/glut.h>

#define EPSILON 0.005
#define PRECISION 1


typedef int    face[4];
typedef face   cube[6];


int grille, cube_controle, axes;
int resolution, resolution_back;
double zoom, rayon;
int largeurImg, hauteurImg, nbrImg;
unsigned char ** volumeImg;
unsigned int *valMax;
pr3   * points;
cube  *  cubes;

listepr3 ** resultat;
listepr3 *  centres;

int nbPts, nbFaces;
int       **  faceUnique;
pr3        *  ptsUnique;


int changement_face[6][4]  = { { 5, 3, 4, 1 }, { 5, 0, 4, 2 }, { 5, 1, 4, 3 }, { 5, 2, 4, 0 }, { 0, 3, 2, 1 }, { 2, 3, 0, 1 } };
int changement_arete[6][4] = { { 1, 2, 3, 0 }, { 2, 2, 2, 0 }, { 3, 2, 1, 0 }, { 0, 2, 0, 0 }, { 1, 1, 1, 1 }, { 3, 3, 3, 3 } };


GLfloat mat_amb[] = { 0.2, 0.2, 0.2, 1.0 };
GLfloat mat_dif[] = { 0.7, 0.5, 0.5, 1.0 };
GLfloat mat_spe[] = { 0.2, 0.2, 0.0, 1.0 };


/* prototypes de fonction */
int indexation(int _i, int _j, int _k);
void saveMaillage (const char *nomFichier, int *pos = NULL);
void calculeNormale (pr3 courant, pr3 normale);
void dichotomie(pr3 _p1, pr3 _p2, int _n, pr3 _p3);
void cube_intersection (cube _c, int _l);
double fonction_potentiel(pr3 _coord, int decalageX = 0, int decalageY = 0, int decalageZ = 0);
int face_polarite(face _f);
int cube_polarite (cube _c);
void calcul_surface(int *pos = NULL);
void construction_surface(int *pos = NULL);



int indexation(int _i, int _j, int _k)
{
	return _k * (resolution + 1) * (resolution + 1) + _j * (resolution + 1) + _i;
}


void saveMaillage (const char *nomFichier, int *pos)
{
	setlocale(LC_ALL,"C");
    int i = 1;/*
	ptrpr3 * p_point;*/
	pr3 normale;
    char tmp[255];
    FILE *fichier;
	
    fichier = fopen(nomFichier,"w");
    if (fichier)
    {
        strcpy(tmp,"# Fichier OBJ : export du programme seg3D\n");
        fwrite(tmp,strlen(tmp),1,fichier);
        strcpy(tmp,"# par Benjamin DUPLEX <benjamin.duplex@gmail.com> -__-\n");
        fwrite(tmp,strlen(tmp),1,fichier);
        sprintf(tmp,"# definition : %d\n",resolution);
        fwrite(tmp,strlen(tmp),1,fichier);
        
		
        sprintf(tmp,"\n# sommets\n");
        fwrite(tmp,strlen(tmp),1,fichier);
		
		for (i=0; i!=nbPts; i++)
		{
			sprintf(tmp,"v %f %f %f\n",ptsUnique[i][0],ptsUnique[i][1],ptsUnique[i][2]);
			fwrite(tmp,strlen(tmp),1,fichier);
		}
		/*
		for(i = 0; i < resolution * resolution * resolution; i++)
		{
			if(resultat[i])
			{
				p_point = resultat[i]->tete;
				
				while(p_point)
				{
					sprintf(tmp,"v %f %f %f\n",p_point->coords[0],p_point->coords[1],p_point->coords[2]);
					fwrite(tmp,strlen(tmp),1,fichier);
					p_point = p_point->suivant;
				}
			}
		}
		*/
		if (pos)
			(*pos)++;
		
        sprintf(tmp,"\n# normales\n");
        fwrite(tmp,strlen(tmp),1,fichier);
		
		for (i=0; i!=nbPts; i++)
		{
			calculeNormale(ptsUnique[i], normale);
			
			sprintf(tmp,"vn %f %f %f\n",normale[0],normale[1],normale[2]);
			fwrite(tmp,strlen(tmp),1,fichier);
		}
		/*
		for(i = 0; i < resolution * resolution * resolution; i++)
		{
			if(resultat[i])
			{
				p_point = resultat[i]->tete;
				
				while(p_point)
				{
					calculeNormale(p_point->coords, normale);
					
					sprintf(tmp,"vn %f %f %f\n",normale[0],normale[1],normale[2]);
					fwrite(tmp,strlen(tmp),1,fichier);
					
					p_point = p_point->suivant;
				}
			}
		}*/
		
		if (pos)
			(*pos)++;
		
		sprintf(tmp,"\n# faces\n");
        fwrite(tmp,strlen(tmp),1,fichier);
        
		for (i=0; i!=nbFaces; i++)
		{
			int n=0;
			strcpy(tmp,"f ");
			
			do
			{
				sprintf(tmp,"%s %d",tmp,faceUnique[i][n]+1);
				n++;
			} while (faceUnique[i][n] != -1);
			
			strcat(tmp,"\n");
			fwrite(tmp,strlen(tmp),1,fichier);
		}
		/*
		int numPt = 1;
		for(i = 0; i < resolution * resolution * resolution; i++)
		{
			if(resultat[i])
			{
				p_point = resultat[i]->tete;
				strcpy(tmp,"f ");
				
				while(p_point)
				{
					sprintf(tmp,"%s %d",tmp,numPt);					
					p_point = p_point->suivant;
					numPt++;
				}
				
				strcat(tmp,"\n");
				fwrite(tmp,strlen(tmp),1,fichier);
			}
		}
		*/
		if (pos)
			(*pos)++;
        
        fclose(fichier);
    }
}


void calculeNormale (pr3 courant, pr3 normale)
{
    float dist1;

    dist1 = fonction_potentiel(courant);
	
	/* f(P) - f(Px)  / delta */
	if (fonction_potentiel(courant,1,0,0) != 1.0)
		normale[0] = -1;
	else if (fonction_potentiel(courant,-1,0,0) != 1.0)
		normale[0] = 1;
	else
		normale[0] = 0;
	
	
	/* f(P) - f(Px)  / delta */
	if (fonction_potentiel(courant,0,1,0) != 1.0)
		normale[1] = -1;
	else if (fonction_potentiel(courant,0,-1,0) != 1.0)
		normale[1] = 1;
	else
		normale[1] = 0;
	
	
	/* f(P) - f(Px)  / delta */
	if (fonction_potentiel(courant,0,0,1) != 1.0)
		normale[2] = -1;
	else if (fonction_potentiel(courant,0,0,1) != 1.0)
		normale[2] = 1;
	else
		normale[2] = 0;
	
	
    dist1  = normale[0] * normale[0];
    dist1 += normale[1] * normale[1];
    dist1 += normale[2] * normale[2];
    dist1  = sqrt(dist1);
    
    if (dist1 > 0)
    {
        normale[0] /= dist1;
        normale[1] /= dist1;
        normale[2] /= dist1;
    }
	
	return;	
}


void dichotomie(pr3 _p1, pr3 _p2, int _n, pr3 _p3)
{
	int fp1, fp2, fp3;
	
	if(_n > 0)
	{
		pr3_ajouter(_p1, _p2, _p3);
		pr3_multiplier_coeff(_p3, 0.5, _p3);
		
		fp1 = (fonction_potentiel(_p1) > 0.5);
		fp2 = (fonction_potentiel(_p2) > 0.5);
		fp3 = (fonction_potentiel(_p3) > 0.5);
		
		if(fp1 == fp3)
			pr3_copier(_p3, _p1);
		else
			pr3_copier(_p3, _p2);
		
		dichotomie(_p1, _p2, _n - 1, _p3);
	}
}


void cube_intersection (cube _c, int _l)
{
	int i, j, id1, id2, complet, f, fsuiv, fmarque[6], modif, fp1, fp2;
	pr3 p1, p2, pinter;
		
	id1 = 1;
	id2 = 0;
	
	f       =  0;
	fsuiv   = -1;
	complet =  0;
	
	resultat[_l] = listepr3_creer();
	
	for(j = 0; j < 6; j++)
		fmarque[j] = 0;
	
	fmarque[f] = 1;
	
	for(j = 0; j < 6 && !complet; j++)
	{
		modif = 0;
		
		for(i = 0; i < 4 && !complet; i++)
		{
			fp1 = (fonction_potentiel(points[_c[f][id1]]) > 0.5);
			fp2 = (fonction_potentiel(points[_c[f][id2]]) > 0.5);
			
			if(fp1 != fp2)
			{
				pr3_copier(points[_c[f][id1]], p1);
				pr3_copier(points[_c[f][id2]], p2);					
				dichotomie(p1, p2, 10, pinter);
			
				fsuiv = changement_face[f][id1];
				
				if(!fmarque[fsuiv])
				{
					modif = 1;
					
					id2 = (changement_arete[f][id1] + 1) % 4;
					id1 = (id2 + 1) % 4;
					
					fmarque[fsuiv] = 1;
					f = fsuiv;
				}
				else
					complet = 1;
				
				listepr3_ajouter(resultat[_l], pinter[0], pinter[1], pinter[2]);	
			}
			else
			{
				id2 = id1;
				id1 = (id1 + 1) % 4;
			}
		}
		
		if(!modif)
		{
			fmarque[f] = 1;
			f++;
		}
	}
}


double fonction_potentiel(pr3 _coord, int decalageX, int decalageY, int decalageZ)
{
	int x = (int)( _coord[0] * (largeurImg-1)) + ((int)largeurImg/2) + decalageX;
	int y = (int)( _coord[1] * (hauteurImg-1)) + ((int)hauteurImg/2) + decalageY;
	int z = (int)(-_coord[2] * (nbrImg-1    )) + ((int)nbrImg/2    ) + decalageZ;
	
	if (x<0)
		x = 0;
	else if (x>=largeurImg)
		x = largeurImg - 1;
	
	if (y<0)
		y = 0;
	else if (y>=hauteurImg)
		y = hauteurImg - 1;
	
	if (z<0)
		z = 0;
	else if (z>=nbrImg)
		z = nbrImg - 1;
	
	return (float)volumeImg[z][y*largeurImg+x] / valMax[z];
}


int face_polarite(face _f)
{
	int i, s;
	
	s = 0;
	for(i = 0; i < 4; i++)
		s += (fonction_potentiel(points[_f[i]]) > 0.5);
	
	return (s != 0 && s != 4);
}


int cube_polarite (cube _c)
{
	int i;
	
	for(i = 0; i < 4; i++)
	{
		if(face_polarite(_c[i]) == 1)
			return 1;
	}
	
	return 0;
}


void calcul_surface (int *pos)
{
	long i, etape, max;
	
	etape = resolution * resolution;
	max   = resolution * etape;
	
 	for (i=0; i<max; i++)
	{
		if (resultat[i])
		{
			/*****************************************************************************************************************/
/* 			listepr3_vider(resultat[i]);  */
/* 			free(resultat[i]);  */
			
			resultat[i] = NULL;
		}
		
		if(cube_polarite(cubes[i]))
			cube_intersection(cubes[i], i);
		
		if ( (i%etape) == 0 )
			if (pos)
				(*pos)++;
	}
}


void construction_surface(int *pos)
{
	int i, j, k, l;
	
	if (points)
	{
 		free(points);
 		free(cubes);
	}
		
	points = (pr3 *)malloc(sizeof(pr3) * (resolution + 1) * (resolution + 1) * (resolution + 1));
	
	for(k = 0; k <= resolution; k++)
	{	
		for(j = 0; j <= resolution; j++)
		{
			for(i = 0; i <= resolution; i++)
			{
				l = indexation(i, j, k);
				
				points[l][0] = -0.5 + (double)i / (double)(resolution);
				points[l][1] = -0.5 + (double)j / (double)(resolution);
				points[l][2] =  0.5 - (double)k / (double)(resolution);
			}
		}
	}
	
	cubes    = (cube *)     malloc(sizeof(cube)     * resolution * resolution * resolution);
	resultat = (listepr3 **)malloc(sizeof(listepr3) * resolution * resolution * resolution);
	
	for(i = 0; i < resolution * resolution * resolution; i++)
		resultat[l] = NULL;
	
	l = 0;
	for(k = 0; k < resolution; k++)
	{
		for(j = 0; j < resolution; j++)
		{
			for(i = 0; i < resolution; i++)
			{
				cubes[l][0][0] = indexation(i    , j    , k    );
				cubes[l][0][1] = indexation(i    , j + 1, k    );
				cubes[l][0][2] = indexation(i + 1, j + 1, k    );
				cubes[l][0][3] = indexation(i + 1, j    , k    );
				
				cubes[l][1][0] = indexation(i + 1, j    , k    );
				cubes[l][1][1] = indexation(i + 1, j + 1, k    );
				cubes[l][1][2] = indexation(i + 1, j + 1, k + 1);
				cubes[l][1][3] = indexation(i + 1, j    , k + 1);
				
				cubes[l][2][0] = indexation(i + 1, j    , k + 1);
				cubes[l][2][1] = indexation(i + 1, j + 1, k + 1);
				cubes[l][2][2] = indexation(i    , j + 1, k + 1);
				cubes[l][2][3] = indexation(i    , j    , k + 1);
				
				cubes[l][3][0] = indexation(i    , j    , k + 1);
				cubes[l][3][1] = indexation(i    , j + 1, k + 1);
				cubes[l][3][2] = indexation(i    , j + 1, k    );
				cubes[l][3][3] = indexation(i    , j    , k    );
				
				cubes[l][4][0] = indexation(i    , j + 1, k    );
				cubes[l][4][1] = indexation(i    , j + 1, k + 1);
				cubes[l][4][2] = indexation(i + 1, j + 1, k + 1);
				cubes[l][4][3] = indexation(i + 1, j + 1, k    );
				                           
				cubes[l][5][0] = indexation(i    , j    , k + 1);
				cubes[l][5][1] = indexation(i    , j    , k    );
				cubes[l][5][2] = indexation(i + 1, j    , k    );
				cubes[l][5][3] = indexation(i + 1, j    , k + 1);
				
				l++;
			}
		}
	}

	calcul_surface(pos);
}


int ptDoublon (ptrpr3 *pt)
{
	bool egal;
	int i;
	
	for (i=0; i<nbPts; i++)
	{
		egal   = (ptsUnique[i][0] == pt->coords[0]);
		egal &= (ptsUnique[i][1] == pt->coords[1]);
		egal &= (ptsUnique[i][2] == pt->coords[2]);
		if (egal)
			return i;
	}
	
	return -1;
}


void volume::chercherSurfaceImplicite (string nomFichier, int *pos)
{
	int i,nbPtFace;
	ptrpr3 * p_point;
	
	largeurImg = this->largeur;
	hauteurImg = this->hauteur;
	nbrImg = this->nbr;
	volumeImg = this->donnees;
	valMax = this->valeurMax;
	resolution      = volume::RESOLUTION_SURFACES_IMPLICITES;
	resolution_back = resolution;
	grille = 1;
	cube_controle = 0;
	axes = 1;
	points = NULL;
	
	construction_surface(pos);
	
	nbPts = 0;
	nbFaces = 0;
	ptsUnique = (pr3 *)malloc(sizeof(pr3) * (resolution + 1) * (resolution + 1) * (resolution + 1));
	faceUnique = (int **)malloc(sizeof(int) * resolution * resolution * resolution);
	
	for(i = 0; i < resolution * resolution * resolution; i++)
	{
		if(resultat[i])
		{
			faceUnique[nbFaces] = (int *)malloc(sizeof(int) * 100);
			nbPtFace = 0;
			
			p_point = resultat[i]->tete;
			
			while(p_point)
			{
				int posPt = ptDoublon(p_point);
				
				if (posPt == -1) /* pt unique */
				{
					ptsUnique[nbPts][0] = p_point->coords[0];
					ptsUnique[nbPts][1] = p_point->coords[1];
					ptsUnique[nbPts][2] = p_point->coords[2];
					faceUnique[nbFaces][nbPtFace] = nbPts;
					nbPts++;
				}
				else /* pt existant */
					faceUnique[nbFaces][nbPtFace] = posPt;
				
				p_point = p_point->suivant;
				nbPtFace++;
			}
			
			faceUnique[nbFaces][nbPtFace] = -1;
			nbFaces++;
		}
	}
	
	saveMaillage(nomFichier.c_str(), pos);
	
	free(points);
	free(cubes);
	free(centres);
	free(ptsUnique);
	
	for(i = 0; i < resolution * resolution * resolution; i++)
	{
		if (resultat[i])
		{
			ptrpr3 * p_point;
			p_point = resultat[i]->tete;
			
			while (p_point)
			{
				resultat[i]->tete = resultat[i]->tete->suivant;
				free(p_point);
				p_point = resultat[i]->tete;
			}
			free(resultat[i]);
		}
	}
	
	for (i=0; i!=nbFaces; i++)
		free(faceUnique[i]);
	
	free(resultat);
	free(faceUnique);
}
