#include "volume.h"


/*
 *       FICHIER AU FORMAT DV
 * 
 * Structure :
 *
 * DV     : mot magique permettant de savoir qu'il s'agit d'un fichier au format DV
 * L H N  : trois int en clair indiquant la largeur, la hauteur et le nombre d'image
 * T      : un int en clair indiquand l'encodage du fichier (1 = BIT, 8 = OCTET...)
 * images : les images stockes les unes  la suite des autres (type 1 = codage bit, type 8 = codage octet...)
 *
 */


void volume::chargerDV (const char *fichierImg, int *pos)
{
	string tmp;
	istringstream ligne;
	int cpt, val;
	char c;
	
	ifstream fichierDV (fichierImg, ios::in | ios::binary);
	
	if (!fichierDV.is_open())
		cout << "[-] volume::chargerDV > Impossible d'ouvrir le fichier " << fichierImg << endl;
	else
	{
		int l,h,n,f;
		
		/* lecture valeur magique */
		getline(fichierDV, tmp);
		if (tmp != "DV")
		{
			cerr << "[-] volume::chargerDV > Le fichier " << fichierImg << "n'est pas un fichier DV valide.\n";
			return;
		}
		
		/* lecture taille image */
		fichierDV >> l >> h >> n;
		
		/* lecture du nombre de bit de codage */
		fichierDV >> f;
		if (f == 1)
			isBinaire = true;
		else
			f /= OCTET;
		
		/* on rcupre le retour charriot */
		c = fichierDV.get();
		
		setInfos (n, f, 0, 0, l, h);
		cpt = 0;
		
		if (MODE_VERBOSE)
		{
			cout << "[+] Chargement du fichier DV (";
			cout << largeur << ", " << hauteur << ", " << nbr << ", ";
			cout << "type : " << ((isBinaire)?1:f*OCTET) << ")" << endl;
		}
		
		/* pour toutes les images */
		for (int i=0; i!=nbr; i++)
		{
			/* on lit  partir du fichier */
			for (int j=0; j<hauteur; j++)
			{
				for (int k=0; k<largeur; k++)
				{/*
					if (fichierDV.eof())
					{
						cout << "[-] volume::charger > Fichier imcomplet.\n" << endl;
						exit(-1);
					}
					
					*/
					if (isBinaire)
					{
						if (cpt == 0)
							c = fichierDV.get();
						
						val = (c&(1<<(7-cpt))?BLANC:NOIR);
						setValeurPixel(i,k,hauteur-j-1,val);
						cpt++;
						if (cpt == 8)
							cpt = 0;
					}
					else
					{
						val = 0;
						
						/* valeur du pixel en (j,k) */
						for (int l=0; l<nbrBytes; l++)
						{
							if (!fichierDV.eof())
								val += val*255 + (int)fichierDV.get();
							else
							{
								cout << "[-] volume::charger > Fichier imcomplet.\n";
								exit(-1);
							}
						}
						
						setValeurPixel(i,k,hauteur-j-1,val);
					}
				}
			}
			
			/* incrmentation du compteur pour l'affichage */			
			if (pos)
				(*pos)++;
			
			chercherBorne(i);
		}
		
		fichierDV.close();
	}
}


void volume::sauvegarderDV (string fichierImg, int *pos)
{
	fichierImg+=".dv";
	
	ofstream fichierDV (fichierImg.c_str(), ios::out | ios::binary);
	
	if (!fichierDV.is_open())
		cout << "[-] volume::sauvegarderDV > Impossible d'ouvrir le fichier " << fichierImg << endl;
	else
	{	
		int tailleExport;
		
		if (isBinaire)
			tailleExport = BIT;
		else
			tailleExport = OCTET * nbrBytes;
		
		if (MODE_VERBOSE)
		{
			cout << "[+] Sauvegarde du fichier DV (";
			cout << largeur << ", " << hauteur << ", " << nbr << ", ";
			cout << "type : " << tailleExport << ")" << endl;
		}
		
		char tmp;
		int cpt, val;
		
		fichierDV << "DV\n";
		fichierDV << largeur << " " << hauteur << " " << nbr << "\n";
		fichierDV << tailleExport << "\n";
		
		cpt = 0;
		tmp = 0;
		for (int i=0; i!=nbr; i++)
		{
			for (int j=0; j!=hauteur; j++)
			{
				for (int k=0; k!=largeur; k++)
				{
					if (tailleExport == BIT)
					{
						if (cpt == 8)
						{
							fichierDV << tmp;
							cpt = 0;
							tmp = 0;
						}
						
						val = (getValeurPixel(i,k,hauteur-j-1) == BLANC)?1:0;
						tmp |= (val << (7 - cpt));
						cpt++;
					}
					else
					{
						char c;
						for (int l=nbrBytes-1; l>=0; l--)
						{
							c = getValeurOctet(i,k,hauteur-j-1,l);
							fichierDV << c;
						}
					}
				}
			}
		}
		
		if (tailleExport == BIT)
			fichierDV << tmp;
		
		if (pos)
			(*pos)++;
		
		fichierDV.close();
	}
}
