#include "volume.h"


/*
 *       FICHIER AU FORMAT 3D
 *
 * Toutes les donnes sont  la suite.
 * 
 * Structure :
 *
 * L      : un int indiquant la largeur des images
 * H      : un int indiquant la hauteur des images
 * N      : un int indiquant le nombre d'images
 * T      : un char indiquant le type de l'image (0 = BINAIRE, 1 = 16 couleurs, 2 = 256 couleurs)
 * ...    : la suite du header (63 octets)
 * images : les images stockes les unes  la suite des autres (type BINAIRE = codage bit, sinon codage octet)
 *
 */


void volume::charger3D (const char *fichierImg, int *pos)
{	
	ifstream fichier3D (fichierImg, ios::in | ios::binary);
	
	if (!fichier3D.is_open())
		cout << "[-] volume::charger3D > Impossible d'ouvrir le fichier " << fichierImg << endl;
	else
	{
		int type, cpt, val;
		int l,h,n;
		string tmp;
		char c;
		
		fichier3D >> tmp;
		if (tmp == "VOXELO")
		{
			unsigned char typeVoxelo;
			fichier3D >> l >> h >> n >> typeVoxelo;
			if (typeVoxelo == 2)
				type = FORMAT_3D_BINAIRE;
			else if (typeVoxelo == 16)
				type = FORMAT_3D_16;
			else
				type = FORMAT_3D_256;
			
			/*  voir, dcalage header */
		}
		else
		{
			fichier3D.close();
			fichier3D.open(fichierImg, ios::in | ios::binary);
			
			/* lecture de la largeur de l'image */
			char c1, c2, c3, c4;
			c1 = fichier3D.get();
			l  = (int)c1;
			c2 = fichier3D.get();
			l += (int)c2 * 255;
			c3 = fichier3D.get();
			l += (int)c3 * 255 * 255;
			c4 = fichier3D.get();
			l += (int)c4 * 255 * 255 * 255;
			
			/* lecture de la hauteur de l'image */
			c1 = fichier3D.get();
			h  = (int)c1;
			c2 = fichier3D.get();
			h += (int)c2 * 255;
			c3 = fichier3D.get();
			h += (int)c3 * 255 * 255;
			c4 = fichier3D.get();
			h += (int)c4 * 255 * 255 * 255;
			
			/* lecture du nombre d'image */
			c1 = fichier3D.get();
			n  = (int)c1;
			c2 = fichier3D.get();
			n += (int)c2 * 255;
			c3 = fichier3D.get();
			n += (int)c3 * 255 * 255;
			c4 = fichier3D.get();
			n += (int)c4 * 255 * 255 * 255;
			
			l = abs(l);
			h = abs(h);
			n = abs(n);
			
			/* lecture de type de l'image */
			type = (int)fichier3D.get();
		}
		
		setInfos (n, 1, 0, 0, l, h);
		isBinaire = (type == FORMAT_3D_BINAIRE);
		
		/* on passe le header */
		for (int i=0; i<63; i++)
			c = fichier3D.get();
		
		/* puis on rcupre l'image */
		cpt = 0;
		
		if (MODE_VERBOSE)
		{
			cout << "[+] Chargement du fichier 3D (";
			cout << largeur << ", " << hauteur << ", " << nbr << ", ";
			cout << "type : " << type << ")" << endl;
		}
		
		for (int i=0; i!=nbr; i++)
		{
			/* on lit  partir du fichier */
			for (int j=0; j<hauteur; j++)
			{
				for (int k=0; k<largeur; k++)
				{/*
					if (fichier3D.eof())
					{
						cout << "[-] volume::charger > Fichier imcomplet.\n" << endl;
						exit(-1);
					}
					*/
					if (type == FORMAT_3D_BINAIRE)
					{
						if (cpt == 0)
							c = fichier3D.get();
						
						val = (c&(1<<cpt)?BLANC:NOIR);						
						setValeurPixel(i,k,hauteur-j-1,val);
						cpt++;
						if (cpt == 8)
							cpt = 0;
					}
					else
					{
						val = (int)fichier3D.get();
						setValeurPixel(i,k,hauteur-j-1,val);
					}
				}
			}
			
			/* incrmentation du compteur pour l'affichage */			
			if (pos)
				(*pos)++;
			
			chercherBorne(i);
		}
		
		fichier3D.close();
	}
}


void volume::sauvegarder3D (string fichierImg, int *pos)
{
	fichierImg+=".3d";
	
	ofstream fichier3D (fichierImg.c_str(), ios::out | ios::binary);
	
	if (!fichier3D.is_open())
		cout << "[-] volume::sauvegarder3D > Impossible d'ouvrir le fichier " << fichierImg << endl;
	else
	{
		if (MODE_VERBOSE)
		{
			cout << "[+] Sauvegarde du fichier 3D (";
			cout << largeur << ", " << hauteur << ", " << nbr << ", ";
			cout << "type : " << !isBinaire << ")" << endl;
		}
		
		char c;
		int tmp, val, cpt;
		
		/* criture de la largeur de l'image */
		tmp = largeur;
		for (int i=0; i!=4; i++, tmp/=255)
		{
			c = (char)(tmp%255);
			fichier3D << c;
		}
		
		/* criture de la hauteur de l'image */
		tmp = hauteur;
		for (int i=0; i!=4; i++, tmp/=255)
		{
			c = (char)(tmp%255);
			fichier3D << c;
		}
		
		/* criture du nombre d'image */
		tmp = largeur;
		for (int i=0; i!=4; i++, tmp/=255)
		{
			c = (char)(tmp%255);
			fichier3D << c;
		}
		
		/* criture du type de l'image */
		if (isBinaire)
			c = (char)0;
		else
			c = (char)1;
		
		fichier3D << c;
		
		/* remplissage du header */
		c = (char)0;
		for (int i=0; i<63; i++)
			fichier3D << c;
		
		cpt = 0;
		for (int i=0; i!=nbr; i++)
		{
			for (int j=0; j!=hauteur; j++)
			{
				for (int k=0; k!=largeur; k++)
				{
					if (isBinaire)
					{
						if (cpt == 8)
						{
							fichier3D << c;
							cpt = 0;
							c = 0;
						}
						
						val = (getValeurPixel(i,k,hauteur-j-1) == BLANC)?1:0;
						c |= (val << cpt);
						cpt++;
					}
					else
						fichier3D << (char)getValeurPixel(i,k,hauteur-j-1);
				}
			}
		}
		
		if (isBinaire)
			fichier3D << c;
		
		if (pos)
			(*pos)++;
		
		fichier3D.close();
	}
}
