#ifndef VOLUME_H
#define VOLUME_H


/* include c++ */
using namespace std;
#include <iostream>
#include <stdlib.h>
#include <fstream>
#include <sstream>
#include <math.h>

#ifndef PI
	#define PI 3.14159265
#endif


/* include */
#include "fonction.h"
#include "chrono.h"
#include "elementStruct.h"
#include "fichier_obj.h"


/* define : type de codage des images */
#define	CODAGE_UNDEFINED 			0
#define	CODAGE_8_BITS_UNSIGNED		1
#define	CODAGE_16_BITS_UNSIGNED		2

#define BIT							1
#define OCTET						8
#define OCTET						8

#define BLANC  					  255
#define GRIS   					  127
#define NOIR     					0

#define ID_EROSION					1
#define ID_DILATATION				2

/* dimension */
#define DIM_2D						2
#define DIM_3D						3
#define DIM_4D						4

/* format de fichier */
#define FORMAT_RAW					0
#define FORMAT_DV					1
#define FORMAT_3D					2
#define FORMAT_OBJ					3

/* dtail du fichier 3D */
#define FORMAT_3D_BINAIRE			0
#define FORMAT_3D_16				1
#define FORMAT_3D_256				2

/* rsolution du calcul de la surface implicite */
#define		RESOLUTION_8			  8
#define		RESOLUTION_16			 16
#define		RESOLUTION_32			 32
#define		RESOLUTION_64			 64
#define		RESOLUTION_128			128


extern bool MODE_VERBOSE;


class volume
{
	private:
		/* taille d'une image (largeur, hauteur) */
		int largeur, hauteur, taille;
		/* nombre d'image pour un temps donn (hauteur du volume) */
		int nbr;
		/* information sur le stockage des fichiers RAW */
		int startImage, espace;
		/* type du codage */
		int nbrBytes;
		/* binaire ou niveau de gris */
		bool isBinaire;
		/* mmoire des images (i.e. le volume numrique  un temps donn) */
		unsigned char **donnees;
		unsigned int *valeurMin;
		unsigned int *valeurMax;
		/* image affichable (i.e. aprs traitement) */
		unsigned char *imageTmp;
		int seuilMin, seuilMax;
		bool isCharge;
		
		void			chercherSurfaceImplicite(string nomFichier, int *pos = NULL);
	
	
	public:
		static int RESOLUTION_SURFACES_IMPLICITES;
		
		
						volume					();
						volume					(int nbrImage, int codage, int debutPremiereImage, int espaceEntreImage, int largeurImage, int hauteurImage);
						~volume					();
		
		void			setInfos				(int nbrImage, int codage, int debutPremiereImage, int espaceEntreImage, int largeurImage, int hauteurImage);
		
		void            convertir8bits          (int *pos = NULL);
		void            convertirOBJ	        (int *pos = NULL);
		void			seuillerHauteurCoupe	(int hauteurCoupe, int valMin, int valMax, bool binariser, int *pos = NULL);
		void			seuiller				(int valMin, int valMax);
		void			seuillerTemporairement	(int valMin, int valMax);
		void			chercherBorne			(int hauteurCoupe);
		
		void			binariser				(int h, int valMin, int valMax, int *pos = NULL);
		
		void			appliquerFonction		(double (&fonction)(double), int hauteurCoupe, int *pos = NULL);
		void			inversion				(int h, int *pos = NULL);
		void			carre					(int h, int *pos = NULL);
		void			exponentielle			(int h, int *pos = NULL);
		void			logarithmique			(int h, int *pos = NULL);
		
		int             getLargeur		    	();
		int             getHauteur  			();
		int             getNbr	  				();
		void			chargerRAW				(const char *fichierImg, int *pos = NULL);
		void			chargerDV				(const char *fichierImg, int *pos = NULL);
		void			charger3D				(const char *fichierImg, int *pos = NULL);
		void			chargerOBJ				(const char *fichierImg, int *pos = NULL);
		void			charger					(const char *fichierImg, int format, int *pos = NULL);
		void			sauvegarderRAW			(string fichierImg, int *pos = NULL);
		void			sauvegarderDV			(string fichierImg, int *pos = NULL);
		void			sauvegarder3D			(string fichierImg, int *pos = NULL);
		void			sauvegarderOBJ			(string fichierImg, int *pos = NULL);
		void			sauvegarder				(string fichierImg, int format, int *pos = NULL);
		unsigned int 	getValeurMinimale 		(int hauteurCoupe);
		unsigned int 	getValeurMaximale 		(int hauteurCoupe);
		
		void			morphoMaths				(int hauteurCoupe, int ID, int *pos = NULL);
		void			dilatation				(int hauteurCoupe=-1, int *pos = NULL);
		void			erosion					(int hauteurCoupe=-1, int *pos = NULL);
		void			peindre					(int i, int j, int k, unsigned int couleurDepart, unsigned int couleurFin);
		void			suppressionParasite		(int *pos = NULL);
		void			boucherTrous			();
		void			contour					(int kMin = -1, int *pos = NULL);
		void			filtreGaussien			(int hauteurCoupe, int *pos = NULL);
		unsigned int	getValeurPixel			(int num, int l, int h);
		unsigned int	getValeurPixel			(unsigned char **tab, int num, int l, int h);
		unsigned int	getValeurOctet			(int num, int l, int h, int octet);
		unsigned int	getValeurOctet			(unsigned char **tab, int num, int l, int h, int octet);
		void			setValeurPixel			(int num, int l, int h, int val);
		void			setValeurPixel			(unsigned char **tab, int num, int l, int h, int val);
		
		void 			expansionDynamique 		(int num, unsigned char **dst);
		unsigned char *	get        				(int hauteur);
		unsigned char *	getBrut    				(int hauteur);
		bool			saveContour				(int img, int i, int j, int *cpt, int *combien, string *listePts);
		void			sauvegarderPoints		(string fichier, string masque);
};


#endif
