#ifndef SEQUENCE_H
#define SEQUENCE_H


/* include c++ */
using namespace std;
#include <iostream>
#include <stdlib.h>
#include <fstream>
#include <sstream>


/* include programme */
#include "volume.h"


extern bool MODE_VERBOSE;


class sequence
{
	private:
		/* indique si une scene a t charge */
		/* 0 : non initialis                 */
		/* 1 : lecture du fichier de conf ok  */
		/* 2 : chargement des images termin  */
		int state;
		/* taille d'une image (largeur, hauteur) */
		int largeur, hauteur;
		/* nombre d'image pour un temps donn (hauteur du volume) */
		int nbrImg;
		/* information sur le stockage des fichiers RAW */
		int startImg, espace;
		/* nom des images */
		string chemin, nomImg;
		/* nombre d'images */
		int tMax;
		/* type du codage */
		int nbrBytes;
		/* listes de toutes les images */
		volume *img;
		int seuilMin, seuilMax;
		
		void			reset							();
	
	
	public:
						sequence						();
						~sequence						();
		bool			isValide						();
		bool			isEmpty							();
		
		
		
		
		int				getLargeur						();
		int				getHauteur						();
		int				getDuree						();
		int				getNombreImage					();
		string          getNomImage                     ();
		unsigned int 	getValeurMinimale				(int temps, int hauteurCoupe);
		unsigned int 	getValeurMaximale				(int temps, int hauteurCoupe);
		/* renvoie l'image en fonction du temps et de la hauteur souhaits */
		unsigned char *	getImage						(int temps, int hauteurCoupe);
		unsigned char *	getImageBrute					(int temps, int hauteurCoupe);
		volume *		getVolume						(int temps);
		
		
		void			sauvegarderPoints				(int temps, string fichier, string masque);
		
		
		/* seuille entirement la scne */
		void			seuiller						(int valMin, int valMax);
		/* seuille toutes les images de la scne  une certaine hauteur */
		void			seuillerImageHauteurCoupe		(int hauteurCoupe, int valMin, int valMax);
		/* seuille toutes les images de la scne  un temps donn */
		void			seuillerImageTemps				(int temps, int valMin, int valMax);
		/* seuille une image  un temps et une hauteur donns */
		void			seuillerImage					(int temps, int hauteurCoupe, int valMin, int valMax);
		/* seuille une image temporairement  un temps donn (la hauteur est la hauteur courante) */
		void			seuillerImageTemporairement		(int valMin, int valMax);
		
		
		
		
		
		/* chargement */		
		static void		lireFichierConfig 				(string path, string fichierConfig, sequence *seq);
		void			lireFichierConfig 				(string path, string fichierConfig);
		static void 	chargerImages 					(string path, string fichierImg, bool all, sequence *seq, int format, int indice = -1, int *pos = NULL);
		void 			chargerImages 					(string path, string fichierImg, bool all, int format, int indice = -1, int *pos = NULL);
		
		/* sauvegarde */
		static void		sauvegarderFichierConfig 		(string path, string fichierConfig, string fichierImg, sequence *seq);
		void			sauvegarderFichierConfig 		(string path, string fichierConfig, string fichierImg);
		static void 	sauvegarderImages 				(string path, string fichierImg, sequence *seq, int format, int *pos = NULL);
		void 			sauvegarderImages 				(string path, string fichierImg, int format, int *pos = NULL);
		
		/* export */
		
		
		/* traitements */
		static void     convertir8bits                  (int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void            convertir8bits3d                (int temps, int *pos = NULL);
		void            convertir8bits4d                (int *pos = NULL);
		
		static void     convertirOBJ                    (int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			convertirOBJ					(int temps, int *pos);
		
		static void		binariser						(int temps, int h, int valMin, int valMax, int dimension, sequence *seq, int *pos = NULL);
		void			binariser2d						(int temps, int h, int valMin, int valMax, int *pos = NULL);
		void			binariser3d						(int temps, int valMin, int valMax, int *pos = NULL);
		void			binariser4d						(int valMin, int valMax, int *pos = NULL);
		
		static void		inversion						(int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			inversion2d						(int temps, int h, int *pos = NULL);
		void			inversion3d						(int temps, int *pos = NULL);
		void			inversion4d						(int *pos = NULL);
		
		static void		carre							(int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			carre2d							(int temps, int h, int *pos = NULL);
		void			carre3d							(int temps, int *pos = NULL);
		void			carre4d							(int *pos = NULL);
		
		static void		exponentielle					(int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			exponentielle2d					(int temps, int h, int *pos = NULL);
		void			exponentielle3d					(int temps, int *pos = NULL);
		void			exponentielle4d					(int *pos = NULL);
		
		static void		logarithmique  					(int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			logarithmique2d					(int temps, int h, int *pos = NULL);
		void			logarithmique3d					(int temps, int *pos = NULL);
		void			logarithmique4d					(int *pos = NULL);
		
		static void		filtreGaussien  				(int temps, int h, int dimension, sequence *seq, int *pos = NULL);
		void			filtreGaussien2d				(int temps, int h, int *pos = NULL);
		void			filtreGaussien3d				(int temps, int *pos = NULL);
		void			filtreGaussien4d				(int *pos = NULL);
		
		static void		dilatation  					(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			dilatation2d					(int temps, int hauteurCoupe, int *pos = NULL);
		void			dilatation3d					(int temps, int *pos = NULL);
		void			dilatation4d					(int *pos = NULL);
		
		static void		erosion  						(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			erosion2d						(int temps, int hauteurCoupe, int *pos = NULL);
		void			erosion3d						(int temps, int *pos = NULL);
		void			erosion4d						(int *pos = NULL);
		
		static void		ouverture						(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			ouverture2d						(int temps, int hauteurCoupe, int *pos = NULL);
		void			ouverture3d						(int temps, int *pos = NULL);
		void			ouverture4d						(int *pos = NULL);
		
		static void		fermeture						(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			fermeture2d						(int temps, int hauteurCoupe, int *pos = NULL);
		void			fermeture3d						(int temps, int *pos = NULL);
		void			fermeture4d						(int *pos = NULL);
		
		static void		suppressionParasite				(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			suppressionParasite3d			(int temps, int *pos = NULL);
		void			suppressionParasite4d			(int *pos = NULL);
		
		static void		contour 						(int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos = NULL);
		void			contour2d						(int temps, int hauteurCoupe, int *pos = NULL);
		void			contour3d						(int temps, int *pos = NULL);
		void			contour4d						(int *pos = NULL);
};


#endif
