#include "sequence.h"



sequence::sequence()
{
	img = NULL;
	state = 0;
	seuilMin = seuilMax = -1;
}


void sequence::reset()
{
	if (!isEmpty())
	{
		if (img)
			for (int i=0; i<tMax; i++)
				img[i].~volume();
			
		
		state = 0;
	}
}


sequence::~sequence()
{
	reset();
}


bool sequence::isValide ()
{
	return state == 2;
}


bool sequence::isEmpty ()
{
	return state == 0;
}


/*
 * Lit le fichier de configuration ("SIZE.txt") pour connaitre les paramtres des volumes
 */
void sequence::lireFichierConfig (string path, string fichierConfig)
{
	reset();
	string tmp = path + fichierConfig;
	if (MODE_VERBOSE)
		cout << "[+] Lecture du fichier de configuration : " << fichierConfig << endl;
	string ligne;
	
	largeur = hauteur = startImg = espace = nbrImg = -1;
	nomImg = "";
	
	ifstream fichier(tmp.c_str(), ifstream::in);
	while (getline(fichier, ligne))
	{
		unsigned int pos = ligne.find(".X",0);
		
		if (pos == ligne.length()-2)
			nomImg = ligne.substr(0, pos+1);
		else if (ligne.substr(0, 12) == "Image Type: ")
		{
			ligne = ligne.substr(12);
			if (ligne == "8-bit Unsigned")
				nbrBytes = CODAGE_8_BITS_UNSIGNED;
			else if (ligne == "16-bit Unsigned")
				nbrBytes = CODAGE_16_BITS_UNSIGNED;
			else
				nbrBytes = CODAGE_UNDEFINED;
		}
		else if (ligne.substr(0, 7) == "Width: ")
		{
			istringstream str2int(ligne.substr(7));
			str2int >> largeur;
		}
		else if (ligne.substr(0, 8) == "Height: ")
		{
			istringstream str2int(ligne.substr(8));
			str2int >> hauteur;
		}
		else if (ligne.substr(0, 23) == "Offset to First Image: ")
		{
			ligne = ligne.substr(23);
			pos = ligne.find(" ",0);
			istringstream str2int(ligne.substr(0,pos));
			str2int >> startImg;
		}
		else if (ligne.substr(0, 18) == "Number of Images: ")
		{
			istringstream str2int(ligne.substr(18));
			str2int >> nbrImg;
		}
		else if (ligne.substr(0, 20) == "Gap Between Images: ")
		{
			ligne = ligne.substr(20);
			pos = ligne.find(" ",0);
			istringstream str2int(ligne.substr(0,pos));
			str2int >> espace;
		}
	}
	fichier.close();
	
	if (MODE_VERBOSE)
	{
		cout << "[+] Informations lues :" << endl;
		cout << "      nom des volumes : " << nomImg << endl;
		cout << "      largeur : " << largeur << endl;
		cout << "      hauteur : " << hauteur << endl;
		cout << "      nbr d'octet : " << nbrBytes << endl;
		cout << "      offset de depart : " << startImg << endl;
		cout << "      nombre d'image : " << nbrImg << endl;
		cout << "      espace entre image : " << espace << endl;
		
		cout << "[+] Lecture du fichier de configuration terminee." << endl;
		cout << "[+] Comptage du nombre de fichier RAW disponible." << endl;
	}
	
	chemin = path;
	int t = 0;
	
	do
	{
		if (fichier.is_open())
			fichier.close();
		
		t++;
		stringstream out;
		out << t;
		ligne = chemin+nomImg+out.str();
		fichier.open(ligne.c_str(),ifstream::in);
		
	} while (fichier.is_open());
	
	tMax = t - 1;
	
	if (MODE_VERBOSE)
		cout << "[+] " << tMax << " fichiers RAW." << endl;
	state = 1;
}


void sequence::lireFichierConfig (string path, string fichierConfig, sequence *seq)
{
	seq->lireFichierConfig(path,fichierConfig);
}


void sequence::chargerImages (string path, string fichierImg, bool all, int format, int indice, int *pos)
{
	ifstream fichier;
	string tmp;
	
	if (format == FORMAT_RAW)
	{
		if (all)
		{
			if (MODE_VERBOSE)
				cout << "[+] Chargement de tous les volumes." << endl;
			
			img = new volume[tMax];
			for (int i=0; i<tMax; i++)
			{
				img[i].setInfos(nbrImg,nbrBytes,startImg,espace,largeur,hauteur);
				stringstream out;
				out << i+1;
				tmp = chemin+nomImg+out.str();
				img[i].charger(tmp.c_str(), format, pos);
				
				if (MODE_VERBOSE)
					cout << "     #" << i+1 << " charge." << endl;
			}
		}
		else
		{
			tMax = 1;
			if (MODE_VERBOSE)
			{
				if (indice == -1)
					cout << "[+] Chargement du premier volume uniquement." << endl;
				else
					cout << "[+] Chargement du volume #" << indice << "." << endl;
			}
			
			img = new volume[1];
			img[0].setInfos(nbrImg,nbrBytes,startImg,espace,largeur,hauteur);
			stringstream out;
			out << indice;
			tmp = chemin+nomImg+out.str();
			img[0].charger(tmp.c_str(), format, pos);
		}
	}
	else
	{
		reset();
		nomImg = fichierImg;
		tMax = 1;
		indice = 1;
		startImg = 0;
		espace = 0;
		img = new volume[1];
		tmp = path+fichierImg;
		img[0].charger(tmp.c_str(), format, pos);
		
		largeur = img[0].getLargeur();
		hauteur = img[0].getHauteur();
		nbrImg = img[0].getNbr();
		nbrBytes = 1;
	}
	
	if (MODE_VERBOSE)
		cout << "[+] Chargement des volumes termine." << endl;
	
	if (format != FORMAT_OBJ)
		state = 2;
}


void sequence::chargerImages (string path, string fichierImg, bool all, sequence *seq, int format, int indice, int *pos)
{
	seq->chargerImages(path, fichierImg, all, format, indice, pos);
}


void sequence::sauvegarderFichierConfig (string path, string fichierConfig, string fichierImg)
{
	string tmp = path + fichierConfig;
	string ligne;
	
	if (MODE_VERBOSE)
		cout << "[+] Sauvegarde du fichier de configuration : " << fichierConfig << endl;
	
	ofstream fichier(tmp.c_str(), ifstream::out);
	
	fichier << fichierImg << ".X\n\n";
	
	fichier << "Image Type: ";
	if (nbrBytes == CODAGE_8_BITS_UNSIGNED)
		fichier << "8-bit Unsigned\n";
	else if (nbrBytes == CODAGE_16_BITS_UNSIGNED)
		fichier << "16-bit Unsigned\n";
	else
		fichier << "erreur\n";
	
	fichier << "Width: " << largeur << " pixels\n";
	fichier << "Height: " << hauteur << " pixels\n";
	fichier << "Offset to First Image: " << startImg << " bytes\n";
	fichier << "Number of Images: " << nbrImg << "\n";
	fichier << "Gap Between Images: " << espace << " bytes\n\n";
	fichier << "White is Zero\n";
	fichier << "Little-Endian Byte Order\n";
	fichier << "Open All Files in Folder\n";
	
	fichier.close();
}


void sequence::sauvegarderFichierConfig (string path, string fichierConfig, string fichierImg, sequence *seq)
{
	seq->sauvegarderFichierConfig (path, fichierConfig, fichierImg);
}


void sequence::sauvegarderPoints (int temps, string fichier, string masque)
{
	img[temps].sauvegarderPoints(fichier, masque);
}


void sequence::sauvegarderImages (string path, string fichierImg, int format, int *pos)
{
	string tmp;
	
	if (MODE_VERBOSE)
		cout << "[+] Sauvegarde des images." << endl;
	
	for (int i=0; i<tMax; i++)
	{
		stringstream out;
		out << i+1;
		tmp = path+fichierImg+"."+out.str();
		img[i].sauvegarder(tmp, format, pos);
		
		if (MODE_VERBOSE)
			cout << "     #" << i+1 << " sauvegardee." << endl;
	}
	
	if (MODE_VERBOSE)
		cout << "[+] Sauvegarde des images terminee." << endl;
}


void sequence::sauvegarderImages (string path, string fichierImg, sequence *seq, int format, int *pos)
{
	seq->sauvegarderImages(path, fichierImg, format, pos);
}


void sequence::seuillerImageTemporairement (int valMin, int valMax)
{
	seuilMin=valMin; seuilMax=valMax;
}


void sequence::seuillerImage (int temps, int hauteurCoupe, int valMin, int valMax)
{
	img[temps].seuillerHauteurCoupe(hauteurCoupe, valMin, valMax, false);
}


void sequence::seuillerImageTemps (int temps, int valMin, int valMax)
{
	img[temps].seuillerTemporairement(valMin, valMax);
}


void sequence::seuillerImageHauteurCoupe (int hauteurCoupe, int valMin, int valMax)
{
	for (int i=1; i<tMax+1; i++)
		seuillerImage(i, hauteurCoupe, valMin, valMax);
}


void sequence::seuiller (int valMin, int valMax)
{
	seuilMin = seuilMax = -1;
	
	for (int i=1; i<tMax+1; i++)
		seuillerImageTemps(i, valMin, valMax);
}


int sequence::getLargeur ()
{
	if (state > 0)
		return largeur;
	else
		return -1;
}


int sequence::getHauteur ()
{
	if (state > 0)
		return hauteur;
	else
		return -1;
}


int sequence::getDuree()
{
	if (state > 0)
		return tMax;
	else
		return -1;
}


int sequence::getNombreImage ()
{
	if (state > 0)
		return nbrImg;
	else
		return -1;
}


string sequence::getNomImage ()
{
	return nomImg;
}


unsigned int sequence::getValeurMinimale (int temps, int hauteurCoupe)
{
	return img[temps].getValeurMinimale(hauteurCoupe);
}


unsigned int sequence::getValeurMaximale (int temps, int hauteurCoupe)
{
	return img[temps].getValeurMaximale(hauteurCoupe);
}


unsigned char *sequence::getImage (int temps, int hauteurCoupe)
{
	if (temps < 0)
		temps = 0;

	if (temps >= tMax)
		temps = tMax-1;
	
	img[temps].seuillerTemporairement(seuilMin, seuilMax);
	return img[temps].get(hauteurCoupe);
}


unsigned char *	sequence::getImageBrute (int temps, int hauteurCoupe)
{
	if (temps < 0)
		temps = 0;

	if (temps >= tMax)
		temps = tMax-1;
	
	return img[temps].getBrut(hauteurCoupe);
}


volume *sequence::getVolume (int temps)
{
	if (temps < 0)
		temps = 0;

	if (temps >= tMax)
		temps = tMax-1;
	
	return &img[temps];
}




/* effectue une conversion en 8bits */

void sequence::convertir8bits (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{	
	if (MODE_VERBOSE)
		cout << "[+] Conversion 8bits\n";
	
	hauteurCoupe = -1;
	
	if (dimension == DIM_3D)
		seq->convertir8bits3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->convertir8bits4d(pos);
}


void sequence::convertir8bits3d (int temps, int *pos)
{
	img[temps].convertir8bits(pos);
	nbrBytes = 1;
}


void sequence::convertir8bits4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		convertir8bits3d(temps, pos);
}


/* effectue une conversion en OBJ (surfaces implicites */

void sequence::convertirOBJ (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{	
	hauteurCoupe = -1;
	dimension = -1;
	seq->convertirOBJ(temps,pos);
}


void sequence::convertirOBJ (int temps, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Conversion OBJ (par surfaces implicites), resolution " << volume::RESOLUTION_SURFACES_IMPLICITES << "\n";
	
	img[temps].convertirOBJ(pos);
}


/* binarise l'image */

void sequence::binariser (int temps, int hauteurCoupe, int valMin, int valMax, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer binarisation\n";
	
	if (dimension == DIM_2D)
		seq->binariser2d(temps, hauteurCoupe, valMin, valMax, pos);
	else if (dimension == DIM_3D)
		seq->binariser3d(temps, valMin, valMax, pos);
	else if (dimension == DIM_4D)
		seq->binariser4d(valMin, valMax, pos);
}


void sequence::binariser2d (int temps, int h, int valMin, int valMax, int *pos)
{
	seuilMin = seuilMax = -1;	
	img[temps].binariser(h, valMin, valMax, pos);
}


void sequence::binariser3d (int temps, int valMin, int valMax, int *pos)
{
	binariser2d(temps, -1, valMin, valMax, pos);
	img[temps].convertir8bits();
}


void sequence::binariser4d (int valMin, int valMax, int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		binariser3d(temps, valMin, valMax, pos);
}


/* fonction inversion */

void sequence::inversion (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer fonction inversion\n";
	
	if (dimension == DIM_2D)
		seq->inversion2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->inversion3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->inversion4d(pos);
}


void sequence::inversion2d (int temps, int h, int *pos)
{
	img[temps].inversion(h, pos);
}


void sequence::inversion3d (int temps, int *pos)
{
	inversion2d(temps, -1, pos);
}


void sequence::inversion4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		inversion3d(temps, pos);
}


/* fonction carre */

void sequence::carre (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer fonction carree\n";
	
	if (dimension == DIM_2D)
		seq->carre2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->carre3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->carre4d(pos);
}


void sequence::carre2d (int temps, int h, int *pos)
{
	img[temps].carre(h, pos);
}


void sequence::carre3d (int temps, int *pos)
{
	carre2d(temps, -1, pos);
}


void sequence::carre4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		carre3d(temps, pos);
}


/* fonction exponentielle */

void sequence::exponentielle (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer fonction exponentielle\n";
	
	if (dimension == DIM_2D)
		seq->exponentielle2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->exponentielle3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->exponentielle4d(pos);
}


void sequence::exponentielle2d (int temps, int h, int *pos)
{
	img[temps].exponentielle(h, pos);
}


void sequence::exponentielle3d (int temps, int *pos)
{
	exponentielle2d(temps, -1, pos);
}


void sequence::exponentielle4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		exponentielle3d(temps, pos);
}


/* fonction logarithmique */

void sequence::logarithmique (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer fonction logarithmique\n";
	
	if (dimension == DIM_2D)
		seq->logarithmique2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->logarithmique3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->logarithmique4d(pos);
}


void sequence::logarithmique2d (int temps, int h, int *pos)
{
	img[temps].logarithmique(h, pos);
}


void sequence::logarithmique3d (int temps, int *pos)
{
	logarithmique2d(temps, -1, pos);
}


void sequence::logarithmique4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		logarithmique3d(temps, pos);
}


/* applique un blur sur l'image */

void sequence::filtreGaussien (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer filtre gaussien\n";
	
	if (dimension == DIM_2D)
		seq->filtreGaussien2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->filtreGaussien3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->filtreGaussien4d(pos);
}


void sequence::filtreGaussien2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].filtreGaussien(hauteurCoupe, pos);
}


void sequence::filtreGaussien3d (int temps, int *pos)
{
	filtreGaussien2d(temps, -1, pos);
}


void sequence::filtreGaussien4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		filtreGaussien3d(temps, pos);
}


/* dilatation */

void sequence::dilatation (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer dilatation\n";
	
	if (dimension == DIM_2D)
		seq->dilatation2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->dilatation3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->dilatation4d(pos);
}


void sequence::dilatation2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].dilatation(hauteurCoupe, pos);
}


void sequence::dilatation3d (int temps, int *pos)
{
	dilatation2d(temps, -1, pos);
}


void sequence::dilatation4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		dilatation3d(temps, pos);
}


/* erosion */

void sequence::erosion (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer erosion\n";
	
	if (dimension == DIM_2D)
		seq->erosion2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->erosion3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->erosion4d(pos);
}


void sequence::erosion2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].erosion(hauteurCoupe, pos);
}


void sequence::erosion3d (int temps, int *pos)
{
	erosion2d(temps, -1, pos);
}


void sequence::erosion4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		erosion3d(temps, pos);
}


/* ouverture */

void sequence::ouverture (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer ouverture\n";
	
	if (dimension == DIM_2D)
		seq->ouverture2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->ouverture3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->ouverture4d(pos);
}


void sequence::ouverture2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].erosion(hauteurCoupe, pos);
	img[temps].dilatation(hauteurCoupe, pos);
}


void sequence::ouverture3d (int temps, int *pos)
{
	ouverture2d(temps, -1, pos);
}


void sequence::ouverture4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		ouverture3d(temps, pos);
}


/* fermeture */

void sequence::fermeture (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Appliquer fermeture\n";
	
	if (dimension == DIM_2D)
		seq->fermeture2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->fermeture3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->fermeture4d(pos);
}


void sequence::fermeture2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].dilatation(hauteurCoupe, pos);
	img[temps].erosion(hauteurCoupe, pos);
}


void sequence::fermeture3d (int temps, int *pos)
{
	fermeture2d(temps, -1, pos);
}


void sequence::fermeture4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		fermeture3d(temps, pos);
}


/* suppression des parasites de l'image */

void sequence::suppressionParasite (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Suppression des parasites\n";
	
	hauteurCoupe = -1;
	
	if (dimension == DIM_3D)
		seq->suppressionParasite3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->suppressionParasite4d(pos);
}


void sequence::suppressionParasite3d (int temps, int *pos)
{
	img[temps].suppressionParasite(pos);
}


void sequence::suppressionParasite4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		suppressionParasite3d(temps, pos);
}


/* extraction du contour */

void sequence::contour (int temps, int hauteurCoupe, int dimension, sequence *seq, int *pos)
{
	if (MODE_VERBOSE)
		cout << "[+] Extraction du contour\n";
	
	if (dimension == DIM_2D)
		seq->contour2d(temps, hauteurCoupe, pos);
	else if (dimension == DIM_3D)
		seq->contour3d(temps, pos);
	else if (dimension == DIM_4D)
		seq->contour4d(pos);
}


void sequence::contour2d (int temps, int hauteurCoupe, int *pos)
{
	img[temps].contour(hauteurCoupe, pos);
}


void sequence::contour3d (int temps, int *pos)
{
	contour2d(temps, -1, pos);
}


void sequence::contour4d (int *pos)
{
	for (int temps=0; temps!=tMax; temps++)
		contour3d(temps, pos);
}
