#include "script.h"


vector <string> script::variable;
vector <string> script::valeur;

script::script (string f, sequence *seq)
{
	coeur = seq;
	nomFichier = f;
	affichage = MODE_VERBOSE;
	nbrOperations = 0;
}


script::~script ()
{
}


void script::changerAffichage (bool a)
{
	affichage = a;
}


void script::cacher ()
{
	changerAffichage(false);
}


void script::afficher ()
{
	changerAffichage(true);
}


int script::getNombreOperations ()
{
	calculNombreOperations();
	return nbrOperations;
}


int script::calculNombreOperations ()
{
	nbrOperations = 0;
	ifstream fichierScript (nomFichier.c_str(), ios::in);

	if (!fichierScript.is_open())
	{
		cout << "[-] script::calculNombreOperations > Impossible d'ouvrir le script " << nomFichier << endl;
		return -1;
	}
	
	while (!fichierScript.eof())
	{
		string tmp;
		
		/* lecture d'une ligne et construction du flot de parsing */
		getline(fichierScript, tmp);
		
		if (tmp!="" && tmp[0]!='#')
			nbrOperations++;
	}
	
	fichierScript.close();
	return 0;
}


int script::traiterLigne (string t, sequence *seq, int *pos)
{
	/* variable de parsing */
	string t1, t2, t3, t4, t5;
	bool seuiller, binariser;
	int dim, moment, hauteur, min, max;
	char c;
	istringstream ligne;
	
	/* pointeur sur la fonction */
	void (*fonction)(int, int, int, sequence *, int *);
	
	/* initialisations */
	fonction = NULL;
	min = max = -1;
	seuiller = binariser = false;
	t1 = t2 = t3 = t4 = "";
	ligne.str(t);
	
	
	ligne >> t1;
	
	if (t1 == "Appliquer")
	{
		ligne >> t2;
		if (t2 == "filtre")
		{
			ligne >> t3;
			if (t3 == "gaussien")
				fonction = &sequence::filtreGaussien;
		}
		else if (t2 == "dilatation")
			fonction = &sequence::dilatation;
		else if (t2 == "erosion")
			fonction = &sequence::erosion;
		else if (t2 == "ouverture")
			fonction = &sequence::ouverture;
		else if (t2 == "fermeture")
			fonction = &sequence::fermeture;
		else if (t2 == "suppression")
		{
			ligne >> t3;
			if (t3 == "parasites")
				fonction = &sequence::suppressionParasite;
		}
		else if (t2 == "fonction")
		{
			ligne >> t3;
			if (t3 == "inversion")
				fonction = &sequence::inversion;
			else if (t3 == "carree")
				fonction = &sequence::carre;
			else if (t3 == "exponentielle")
				fonction = &sequence::exponentielle;
			else if (t3 == "logarithmique")
				fonction = &sequence::logarithmique;
		}
		else if (t2 == "binarisation")
		{
			binariser = true;
			ligne >> min >> c >> max;
		}
	}
	else if (t1 == "Extraire")
	{
		ligne >> t2;
		if (t2 == "contour")
			fonction = &sequence::contour;
	}
	else if (t1 == "Convertir")
	{
		ligne >> t2;
		if (t2 == "8bits")
			fonction = &sequence::convertir8bits;
		if (t2 == "OBJ")
			fonction = &sequence::convertirOBJ;
	}
	else if (t1 == "Charger")
	{
		ligne >> t2;
		if (t2 == "config")
		{
			ligne >> t3 >> t4;
			sequence::lireFichierConfig(t3, t4, seq);
			return 0;
		}
		else if (t2 == "fichier")
		{
			ligne >> t3;
			int format = -1;
			string path, fichier;
			
			if (t3 == "RAW")
			{
				format = FORMAT_RAW;
				path = "";
				fichier = "";
				ligne >> min >> max;
			}
			else
			{
				if (t3 == "DV")
					format = FORMAT_DV;
				else if (t3 == "3D")
					format = FORMAT_3D;
				else if (t3 == "OBJ")
					format = FORMAT_OBJ;
				
				ligne >> path >> fichier;
				min = max = 0;
			}
			
			sequence::chargerImages(path, fichier, min==1, seq, format, max, pos);
			return 0;
		}
	}
	else if (t1 == "Sauvegarder")
	{
		ligne >> t2;
		if (t2 == "config")
		{
			ligne >> t3 >> t4 >> t5;
			sequence::sauvegarderFichierConfig(t3, t4, t5, seq);
		}
		else if (t2 == "fichier")
		{
			ligne >> t3;
			int format = -1;
			
			if (t3 == "RAW")
				format = FORMAT_RAW;
			else if (t3 == "DV")
				format = FORMAT_DV;
			else if (t3 == "3D")
				format = FORMAT_3D;
			else if (t3 == "OBJ")
				format = FORMAT_OBJ;
			
			ligne >> t4 >> t5;
			sequence::sauvegarderImages(t4, t5, seq, format);
		}
		
		return 0;
	}
	else if (t1 == "Executer")
	{
		ligne >> t2;
		if (t2 == "script")
		{
			ligne >> t3;
			script sc(t3, seq);
			sc.traiter(pos);
			return 0;
		}
	}
	else if (t1 == "Specifier")
	{
		ligne >> t2;
		if (t2 == "resolution")
		{
			int res;
			ligne >> res;
			if (res%2 == 0)
				volume::RESOLUTION_SURFACES_IMPLICITES = res;
			return 0;
		}
	}
	
	if (fonction==NULL && !binariser && !seuiller)
		return -1;
	
	
	
	/* " 3D " => espace, dimension, 'D', espace */
	ligne >> dim >> c;
	
	
	if (dim == DIM_2D)
	{
		/* "(3,3)" => '(', moment, ',', hauteur, ')' */
		ligne >> c >> moment >> c >> hauteur >> c;
		if (!ligne.good())
			return -1;
	}
	else if (dim == DIM_3D)
	{
		/* "(3)" => '(', moment, ')' */
		ligne >> c >> moment >> c;
		hauteur = -1;
		if (!ligne.good())
			return -1;
	}
	else if (dim == DIM_4D)
	{
		/* rien */
		moment = hauteur = -1;
	}
	else
		return -1;
	
	
	
	if (binariser)
		sequence::binariser(moment,hauteur,min,max,dim,seq,pos);
	else
		fonction(moment,hauteur,dim,seq,pos);
	
	return 0;
}


int script::traiter (int *pos)
{
	if (affichage)
		cout << "SCRIPT " << nomFichier << endl;
	
	bool saveVerbose = MODE_VERBOSE;
	MODE_VERBOSE = false;
	calculNombreOperations();	
	
	ifstream fichierScript (nomFichier.c_str(), ios::in);

	if (!fichierScript.is_open())
	{
		cout << "[-] script::traiter > Impossible d'ouvrir le script " << nomFichier << endl;
		return -1;
	}
	
	string tmp;
	int operation;
	int erreur;
	
	operation = 1;
	while (!fichierScript.eof())
	{
		/* lecture d'une ligne et construction du flot de parsing */
		getline(fichierScript, tmp);
		
		/* si le premier caractere est un #, alors c'est une ligne de commentaire */
		if (tmp!="" && tmp[0]!='#')
		{
			if (pos)
				(*pos)++;
			
			if (affichage)
			{
				cout << ((operation<10)?"[0":"[") << operation << ((nbrOperations<10)?"/0":"/") << nbrOperations << "]...";
				cout.flush();
			}
			
			
			if (tmp[0]=='$')
			{
				unsigned int i = tmp.find("=");
				if (i != string::npos)
				{
					bool trouve = false;
					string var = tmp.substr(0,i);
					
					for (unsigned int j=0; j!=script::variable.size(); j++)
					{
						if (script::variable[j] == var)
						{
							trouve = true;
							script::valeur[j] = tmp.substr(i+1);
						}
					}
					
					if (!trouve)
					{
						script::variable.push_back(var);
						script::valeur.push_back(tmp.substr(i+1));
					}
					
					erreur = 0;
				}
				else
					erreur = -1;
			}
			else
			{
				unsigned int posReplace;
				for (unsigned int i=0; i!=script::variable.size(); i++)
				{
					while ((posReplace = tmp.find(script::variable[i])) != string::npos)
						tmp.replace(posReplace, script::variable[i].length(), script::valeur[i]);
				}
				
				erreur = script::traiterLigne(tmp, coeur);
			}
			
			if (erreur==0 && affichage)
				cout << "OK" << endl;
			else if (erreur == -1)
			{
				if (affichage)
					cout << "ERREUR" << endl;
				else
					cout << "[-] script::traiter > Erreur lors du traitement de la commande '" << tmp << "'.\n";
			}
			
			operation++;
		}
	}
	
	fichierScript.close();
	
	if (affichage)
		cout << "/SCRIPT " << nomFichier << endl;
	
	MODE_VERBOSE = saveVerbose;
	return 0;
}


int script::lire (wxTextCtrl *sc)
{
	ifstream fichierScript (nomFichier.c_str(), ios::in);

	if (!fichierScript.is_open())
	{
		cout << "[-] script::lire > Impossible d'ouvrir le script " << nomFichier << endl;
		return -1;
	}
	
	while (!fichierScript.eof())
	{
		string tmp;
		
		/* lecture d'une ligne et construction du flot de parsing */
		getline(fichierScript, tmp);		
		tmp += "\n";
		wxString s(tmp.c_str(), wxConvUTF8);
		sc->AppendText(s);
	}
	
	fichierScript.close();
	return 0;
}


int script::ecrire (wxTextCtrl *sc)
{
	ofstream fichierScript (nomFichier.c_str(), ios::out);

	if (!fichierScript.is_open())
	{
		cout << "[-] script::ecrire > Impossible d'ouvrir le script " << nomFichier << endl;
		return -1;
	}
	
	for (int i=0; i!=sc->GetNumberOfLines(); i++)
	{
		string tmp;
		tmp = string((sc->GetLineText(i)).mb_str(wxConvLibc));		
		fichierScript << tmp << endl;
	}
	
	fichierScript.close();
	return 0;
}
