#ifndef __mcgliste__
#define __mcgliste__


#include <algebre.h>


typedef struct ptrpz2
{
	
	pz2 coords;
	struct ptrpz2 * suivant;
	
} ptrpz2;


typedef struct ptrpr2
{
	
	pr2 coords;
	struct ptrpr2 * suivant;
	
} ptrpr2;


typedef struct ptrpz3
{
	
	pz3 coords;
	struct ptrpz3 * suivant;
	
} ptrpz3;


typedef struct ptrpr3
{
	
	pr3 coords;
	struct ptrpr3 * suivant;
	
} ptrpr3;


typedef struct listepz2
{
	
	int nPoints;

	ptrpz2 * tete, * queue;
	
} listepz2;


typedef struct listepr2
{
	
	int nPoints;

	ptrpr2 * tete, * queue;
	
} listepr2;


typedef struct listepz3
{
	
	int nPoints;

	ptrpz3 * tete, * queue;
	
} listepz3;


typedef struct listepr3
{
	
	int nPoints;

	ptrpr3 * tete, * queue;
	
} listepr3;


listepz2 *	listepz2_creer();

void 		listepz2_ajouter_tete	(listepz2 * _p, int _x, int _y);
void 		listepz2_ajouter_queue	(listepz2 * _p, int _x, int _y);
void 		listepz2_ajouter		(listepz2 * _p, int _x, int _y);

void		listepz2_inserer_avant	(listepz2 * _p, ptrpz2 * _i, int _x, int _y);
void		listepz2_inserer_apres	(listepz2 * _p, ptrpz2 * _i, int _x, int _y);
void		listepz2_inserer		(listepz2 * _p, ptrpz2 * _i, int _x, int _y);

void		listepz2_supprimer_tete	(listepz2 * _p);
void		listepz2_supprimer_queue(listepz2 * _p);
void		listepz2_supprimer		(listepz2 * _p, ptrpz2 * _i);
void		listepz2_vider			(listepz2 * _p);

void		listepz2_copier			(listepz2 * _p, listepz2 * _q);

void		listepz2_trier			(listepz2 * _p, int (* _f)(ptrpz2 *, ptrpz2 *));
ptrpz2 *	listepz2_rechercher		(listepz2 * _p, int _x, int _y, int _t);

void		listepz2_afficher		(listepz2 * _p);


listepr2 *	listepr2_creer();

void 		listepr2_ajouter_tete	(listepr2 * _p, double _x, double _y);
void 		listepr2_ajouter_queue	(listepr2 * _p, double _x, double _y);
void 		listepr2_ajouter		(listepr2 * _p, double _x, double _y);

void		listepr2_inserer_avant	(listepr2 * _p, ptrpr2 * _i, double _x, double _y);
void		listepr2_inserer_apres	(listepr2 * _p, ptrpr2 * _i, double _x, double _y);
void		listepr2_inserer		(listepr2 * _p, ptrpr2 * _i, double _x, double _y);

void		listepr2_supprimer_tete	(listepr2 * _p);
void		listepr2_supprimer_queue(listepr2 * _p);
void		listepr2_supprimer		(listepr2 * _p, ptrpr2 * _i);
void		listepr2_vider			(listepr2 * _p);

void		listepr2_copier			(listepr2 * _p, listepr2 * _q);

void		listepr2_trier			(listepr2 * _p, int (* _f)(ptrpr2 *, ptrpr2 *));
ptrpr2 *	listepr2_rechercher		(listepr2 * _p, double _x, double _y, double _t);

void		listepr2_afficher		(listepr2 * _p);


listepz3 *	listepz3_creer();

void 		listepz3_ajouter_tete	(listepz3 * _p, int _x, int _y, int _z);
void 		listepz3_ajouter_queue	(listepz3 * _p, int _x, int _y, int _z);
void 		listepz3_ajouter		(listepz3 * _p, int _x, int _y, int _z);

void		listepz3_inserer_avant	(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z);
void		listepz3_inserer_apres	(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z);
void		listepz3_inserer		(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z);

void		listepz3_supprimer_tete	(listepz3 * _p);
void		listepz3_supprimer_queue(listepz3 * _p);
void		listepz3_supprimer		(listepz3 * _p, ptrpz3 * _i);
void		listepz3_vider			(listepz3 * _p);

void		listepz3_copier			(listepz3 * _p, listepz3 * _q);

void		listepz3_trier			(listepz3 * _p, int (* _f)(ptrpz3 *, ptrpz3 *));
ptrpz3 *	listepz3_rechercher		(listepz3 * _p, int _x, int _y, int _z, int _t);

void		listepz3_afficher		(listepz3 * _p);


listepr3 *	listepr3_creer();

void 		listepr3_ajouter_tete	(listepr3 * _p, double _x, double _y, double _z);
void 		listepr3_ajouter_queue	(listepr3 * _p, double _x, double _y, double _z);
void 		listepr3_ajouter		(listepr3 * _p, double _x, double _y, double _z);

void		listepr3_inserer_avant	(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z);
void		listepr3_inserer_apres	(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z);
void		listepr3_inserer		(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z);

void		listepr3_supprimer_tete	(listepr3 * _p);
void		listepr3_supprimer_queue(listepr3 * _p);
void		listepr3_supprimer		(listepr3 * _p, ptrpr3 * _i);
void		listepr3_vider			(listepr3 * _p);

void		listepr3_copier			(listepr3 * _p, listepr3 * _q);

void		listepr3_trier			(listepr3 * _p, int (* _f)(ptrpr3 *, ptrpr3 *));
ptrpr3 *	listepr3_rechercher		(listepr3 * _p, double _x, double _y, double _z, double _t);

void		listepr3_afficher		(listepr3 * _p);


#endif
