#include <liste.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


listepz2 * listepz2_creer()
{
	listepz2 * p;
	
	p = (listepz2 *)malloc(sizeof(listepz2));
	
	p->nPoints = 0;
	
	p->tete    = NULL;
	p->queue   = NULL;
	
	return p;
}


void listepz2_ajouter_tete(listepz2 * _p, int _x, int _y)
{
	ptrpz2 * p;
	
	p = (ptrpz2 *)malloc(sizeof(pz2));
	p->suivant = NULL;
	pz2_affecter(p->coords, _x, _y);
	
	_p->nPoints++;
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		p->suivant = _p->tete;
		_p->tete = p;
	}
}


void listepz2_ajouter_queue(listepz2 * _p, int _x, int _y)
{
	ptrpz2 * p;
	
	p = (ptrpz2 *)malloc(sizeof(pz2));
	p->suivant = NULL;
	pz2_affecter(p->coords, _x, _y);
	
	_p->nPoints++;
	
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		_p->queue->suivant = p;
		_p->queue = p;
	}
}


void listepz2_ajouter(listepz2 * _p, int _x, int _y)
{
	listepz2_ajouter_queue(_p, _x, _y);
}


void listepz2_inserer_avant(listepz2 * _p, ptrpz2 * _i, int _x, int _y)
{
	ptrpz2 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepz2_ajouter_tete(_p, _x, _y);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpz2 *)malloc(sizeof(pz2));
		insertion->suivant = NULL;
		pz2_affecter(insertion->coords, _x, _y);
			
		p = _p->tete;		
		while(p->suivant != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepz2_inserer_apres(listepz2 * _p, ptrpz2 * _i, int _x, int _y)
{
	ptrpz2 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepz2_ajouter_tete(_p, _x, _y);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpz2 *)malloc(sizeof(pz2));
		insertion->suivant = NULL;
		pz2_affecter(insertion->coords, _x, _y);
		
		p = _p->tete;		
		while(p != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepz2_inserer(listepz2 * _p, ptrpz2 * _i, int _x, int _y)
{
	listepz2_inserer_apres(_p, _i, _x, _y);
}


void listepz2_supprimer_tete(listepz2 * _p)
{
	ptrpz2 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		if(_p->tete == _p->queue)
		{
			_p->tete  = NULL;
			_p->queue = NULL;
		}
		else
			_p->tete = p->suivant;
		
		free(p);
	}
}


void listepz2_supprimer_queue(listepz2 * _p)
{
	ptrpz2 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		while(p->suivant != _p->queue)
			p = p->suivant;
		
		free(_p->queue);
		
		p->suivant = NULL;
		_p->queue = p;
	}
}


void listepz2_supprimer(listepz2 * _p, ptrpz2 * _i)
{
	ptrpz2 * p, * q;
	
	if(_i == _p->tete)
		listepz2_supprimer_tete(_p);
	else
	{
		if(_i == _p->queue)
			listepz2_supprimer_queue(_p);
		else
		{
			_p->nPoints--;

			p = _p->tete;
			while(p->suivant != _i)
				p = p->suivant;
			
			q = p->suivant;
			p->suivant = q->suivant;
			free(q);
		}
	}
}


void listepz2_vider(listepz2 * _p)
{
	while(_p->tete)
		listepz2_supprimer_tete(_p);
}


void listepz2_copier(listepz2 * _p, listepz2 * _q)
{
	ptrpz2 * p;
	
	p = _p->tete;
	while(p)
	{
		listepz2_ajouter(_q, p->coords[0], p->coords[1]);
		
		p = p->suivant;
	}
}


void listepz2_trier(listepz2 * _p, int (* _f)(ptrpz2 *, ptrpz2 *))
{
	ptrpz2 * p, * q;
	int tmp;

	if(_f == NULL)
		return;
		
	p = _p->tete;
	while(p)
	{
		q = p;
		while(q)
		{
			if((*_f)(p, q) > 0)
			{
				tmp  		 = p->coords[0];
				p->coords[0] = q->coords[0];
				q->coords[0] = tmp;
				
				tmp  		 = p->coords[1];
				p->coords[1] = q->coords[1];
				q->coords[1] = tmp;
			}
			
			q = q->suivant;
		}
	
		p = p->suivant;
	}
}


ptrpz2 * listepz2_rechercher(listepz2 * _p, int _x, int _y, int _t)
{
	ptrpz2 * p;
	
	if(_p == NULL)
		return NULL;
	
	p = _p->tete;
	while(p)
	{
		if(abs(_x - p->coords[0]) <= _t && abs(_y - p->coords[1]) <= _t)
			return p;
			
		p = p->suivant;
	}
	
	return NULL;
}


void listepz2_afficher(listepz2 * _p)
{
	ptrpz2 * p;
	
	p = _p->tete;
	while(p)
	{
		printf("(%d, %d) ", p->coords[0], p->coords[1]);
		p = p->suivant;
	}	
	
	printf("\n");
}


listepr2 * listepr2_creer()
{
	listepr2 * p;
	
	p = (listepr2 *)malloc(sizeof(listepr2));
	
	p->nPoints = 0;
	
	p->tete    = NULL;
	p->queue   = NULL;
	
	return p;
}


void listepr2_ajouter_tete(listepr2 * _p, double _x, double _y)
{
	ptrpr2 * p;
	
	p = (ptrpr2 *)malloc(sizeof(pr2));
	p->suivant = NULL;
	pr2_affecter(p->coords, _x, _y);
	
	_p->nPoints++;
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		p->suivant = _p->tete;
		_p->tete = p;
	}
}


void listepr2_ajouter_queue(listepr2 * _p, double _x, double _y)
{
	ptrpr2 * p;
	
	p = (ptrpr2 *)malloc(sizeof(pr2));
	p->suivant = NULL;
	pr2_affecter(p->coords, _x, _y);
	
	_p->nPoints++;
	
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		_p->queue->suivant = p;
		_p->queue = p;
	}
}


void listepr2_ajouter(listepr2 * _p, double _x, double _y)
{
	listepr2_ajouter_queue(_p, _x, _y);
}


void listepr2_inserer_avant(listepr2 * _p, ptrpr2 * _i, double _x, double _y)
{
	ptrpr2 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepr2_ajouter_tete(_p, _x, _y);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpr2 *)malloc(sizeof(pr2));
		insertion->suivant = NULL;
		pr2_affecter(insertion->coords, _x, _y);
		
		p = _p->tete;		
		while(p->suivant != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepr2_inserer_apres(listepr2 * _p, ptrpr2 * _i, double _x, double _y)
{
	ptrpr2 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepr2_ajouter_tete(_p, _x, _y);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpr2 *)malloc(sizeof(pr2));
		insertion->suivant = NULL;
		pr2_affecter(insertion->coords, _x, _y);
		
		p = _p->tete;		
		while(p != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepr2_inserer(listepr2 * _p, ptrpr2 * _i, double _x, double _y)
{
	listepr2_inserer_apres(_p, _i, _x, _y);
}


void listepr2_supprimer_tete(listepr2 * _p)
{
	ptrpr2 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		if(_p->tete == _p->queue)
		{
			_p->tete  = NULL;
			_p->queue = NULL;
		}
		else
			_p->tete = p->suivant;
		
		free(p);
	}
}


void listepr2_supprimer_queue(listepr2 * _p)
{
	ptrpr2 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		while(p->suivant != _p->queue)
			p = p->suivant;
		
		free(_p->queue);
		
		p->suivant = NULL;
		_p->queue = p;
	}
}


void listepr2_supprimer(listepr2 * _p, ptrpr2 * _i)
{
	ptrpr2 * p, * q;
	
	if(_i == _p->tete)
		listepr2_supprimer_tete(_p);
	else
	{
		if(_i == _p->queue)
			listepr2_supprimer_queue(_p);
		else
		{
			_p->nPoints--;

			p = _p->tete;
			while(p->suivant != _i)
				p = p->suivant;
			
			q = p->suivant;
			p->suivant = q->suivant;
			free(q);
		}
	}
}


void listepr2_vider(listepr2 * _p)
{
	while(_p->tete)
		listepr2_supprimer_tete(_p);
}


void listepr2_copier(listepr2 * _p, listepr2 * _q)
{
	ptrpr2 * p;
	
	p = _p->tete;
	while(p)
	{
		listepr2_ajouter(_q, p->coords[0], p->coords[1]);
		
		p = p->suivant;
	}
}


void listepr2_trier(listepr2 * _p, int (* _f)(ptrpr2 *, ptrpr2 *))
{
	ptrpr2 * p, * q;
	double tmp;

	if(_f == NULL)
		return;
		
	p = _p->tete;
	while(p)
	{
		q = p;
		while(q)
		{
			if((*_f)(p, q) > 0)
			{
				tmp  		 = p->coords[0];
				p->coords[0] = q->coords[0];
				q->coords[0] = tmp;
				
				tmp  		 = p->coords[1];
				p->coords[1] = q->coords[1];
				q->coords[1] = tmp;
			}
			
			q = q->suivant;
		}
	
		p = p->suivant;
	}
}


ptrpr2 * listepr2_rechercher(listepr2 * _p, double _x, double _y, double _t)
{
	ptrpr2 * p;
	
	if(_p == NULL)
		return NULL;
	
	p = _p->tete;
	while(p)
	{
		if(fabs(_x - p->coords[0]) <= _t && fabs(_y - p->coords[1]) <= _t)
			return p;
			
		p = p->suivant;
	}
	
	return NULL;
}


void listepr2_afficher(listepr2 * _p)
{
	ptrpr2 * p;
	
	p = _p->tete;
	while(p)
	{
		printf("(%f, %f) ", p->coords[0], p->coords[1]);
		p = p->suivant;
	}	
	
	printf("\n");
}


listepz3 * listepz3_creer()
{
	listepz3 * p;
	
	p = (listepz3 *)malloc(sizeof(listepz3));
	
	p->nPoints = 0;
	
	p->tete    = NULL;
	p->queue   = NULL;
	
	return p;
}


void listepz3_ajouter_tete(listepz3 * _p, int _x, int _y, int _z)
{
	ptrpz3 * p;
	
	p = (ptrpz3 *)malloc(sizeof(pz3));
	p->suivant = NULL;
	pz3_affecter(p->coords, _x, _y, _z);
	
	_p->nPoints++;
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		p->suivant = _p->tete;
		_p->tete = p;
	}
}


void listepz3_ajouter_queue(listepz3 * _p, int _x, int _y, int _z)
{
	ptrpz3 * p;
	
	p = (ptrpz3 *)malloc(sizeof(pz3));
	p->suivant = NULL;
	pz3_affecter(p->coords, _x, _y, _z);
	
	_p->nPoints++;
	
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		_p->queue->suivant = p;
		_p->queue = p;
	}
}


void listepz3_ajouter(listepz3 * _p, int _x, int _y, int _z)
{
	listepz3_ajouter_queue(_p, _x, _y, _z);
}


void listepz3_inserer_avant(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z)
{
	ptrpz3 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepz3_ajouter_tete(_p, _x, _y, _z);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpz3 *)malloc(sizeof(pz3));
		insertion->suivant = NULL;
		pz3_affecter(insertion->coords, _x, _y, _z);
	
		p = _p->tete;		
		while(p->suivant != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepz3_inserer_apres(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z)
{
	ptrpz3 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepz3_ajouter_tete(_p, _x, _y, _z);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpz3 *)malloc(sizeof(pz3));
		insertion->suivant = NULL;
		pz3_affecter(insertion->coords, _x, _y, _z);
	
		p = _p->tete;		
		while(p != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepz3_inserer(listepz3 * _p, ptrpz3 * _i, int _x, int _y, int _z)
{
	listepz3_inserer_apres(_p, _i, _x, _y, _z);
}


void listepz3_supprimer_tete(listepz3 * _p)
{
	ptrpz3 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		if(_p->tete == _p->queue)
		{
			_p->tete  = NULL;
			_p->queue = NULL;
		}
		else
			_p->tete = p->suivant;
		
		free(p);
	}
}


void listepz3_supprimer_queue(listepz3 * _p)
{
	ptrpz3 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		while(p->suivant != _p->queue)
			p = p->suivant;
		
		free(_p->queue);
		
		p->suivant = NULL;
		_p->queue = p;
	}
}


void listepz3_supprimer(listepz3 * _p, ptrpz3 * _i)
{
	ptrpz3 * p, * q;
	
	if(_i == _p->tete)
		listepz3_supprimer_tete(_p);
	else
	{
		if(_i == _p->queue)
			listepz3_supprimer_queue(_p);
		else
		{
			_p->nPoints--;

			p = _p->tete;
			while(p->suivant != _i)
				p = p->suivant;
			
			q = p->suivant;
			p->suivant = q->suivant;
			free(q);
		}
	}
}


void listepz3_vider(listepz3 * _p)
{
	while(_p->tete)
		listepz3_supprimer_tete(_p);
}


void listepz3_copier(listepz3 * _p, listepz3 * _q)
{
	ptrpz3 * p;
	
	p = _p->tete;
	while(p)
	{
		listepz3_ajouter(_q, p->coords[0], p->coords[1], p->coords[2]);
		
		p = p->suivant;
	}
}


void listepz3_trier(listepz3 * _p, int (* _f)(ptrpz3 *, ptrpz3 *))
{
	ptrpz3 * p, * q;
	int tmp;

	if(_f == NULL)
		return;
		
	p = _p->tete;
	while(p)
	{
		q = p;
		while(q)
		{
			if((*_f)(p, q) > 0)
			{
				tmp  		 = p->coords[0];
				p->coords[0] = q->coords[0];
				q->coords[0] = tmp;
				
				tmp  		 = p->coords[1];
				p->coords[1] = q->coords[1];
				q->coords[1] = tmp;
				
				tmp  		 = p->coords[2];
				p->coords[2] = q->coords[2];
				q->coords[2] = tmp;
			}
			
			q = q->suivant;
		}
	
		p = p->suivant;
	}
}


ptrpz3 * listepz3_rechercher(listepz3 * _p, int _x, int _y, int _z, int _t)
{
	ptrpz3 * p;
	
	if(_p == NULL)
		return NULL;
	
	p = _p->tete;
	while(p)
	{
		if(abs(_x - p->coords[0]) <= _t && abs(_y - p->coords[1]) <= _t && abs(_z - p->coords[2]) <= _t)
			return p;
			
		p = p->suivant;
	}
	
	return NULL;
}


void listepz3_afficher(listepz3 * _p)
{
	ptrpz3 * p;
	
	p = _p->tete;
	while(p)
	{
		printf("(%d, %d, %d) ", p->coords[0], p->coords[1], p->coords[2]);
		p = p->suivant;
	}	
	
	printf("\n");
}


listepr3 * listepr3_creer()
{
	listepr3 * p;
	
	p = (listepr3 *)malloc(sizeof(listepr3));
	
	p->nPoints = 0;
	
	p->tete    = NULL;
	p->queue   = NULL;
	
	return p;
}


void listepr3_ajouter_tete(listepr3 * _p, double _x, double _y, double _z)
{
	ptrpr3 * p;
	
	p = (ptrpr3 *)malloc(sizeof(pr3));
	p->suivant = NULL;
	pr3_affecter(p->coords, _x, _y, _z);
	
	_p->nPoints++;
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		p->suivant = _p->tete;
		_p->tete = p;
	}
}


void listepr3_ajouter_queue(listepr3 * _p, double _x, double _y, double _z)
{
	ptrpr3 * p;
	
	p = (ptrpr3 *)malloc(sizeof(pr3));
	p->suivant = NULL;
	pr3_affecter(p->coords, _x, _y, _z);
	
	_p->nPoints++;
	
	if(_p->tete == NULL)
	{
		_p->tete  = p;
		_p->queue = p;
	}
	else
	{
		_p->queue->suivant = p;
		_p->queue = p;
	}
}


void listepr3_ajouter(listepr3 * _p, double _x, double _y, double _z)
{
	listepr3_ajouter_queue(_p, _x, _y, _z);
}


void listepr3_inserer_avant(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z)
{
	ptrpr3 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepr3_ajouter_tete(_p, _x, _y, _z);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpr3 *)malloc(sizeof(pr3));
		insertion->suivant = NULL;
		pr3_affecter(insertion->coords, _x, _y, _z);
		
		p = _p->tete;		
		while(p->suivant != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepr3_inserer_apres(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z)
{
	ptrpr3 * p, * insertion;
	
	if(_i == _p->tete || _i == NULL)
		listepr3_ajouter_tete(_p, _x, _y, _z);
	else
	{
		_p->nPoints++;
		
		insertion = (ptrpr3 *)malloc(sizeof(pr3));
		insertion->suivant = NULL;
		pr3_affecter(insertion->coords, _x, _y, _z);
		
		p = _p->tete;		
		while(p != _i)
			p = p->suivant;
			
		insertion->suivant = p->suivant;
		p->suivant = insertion;
	}		
}


void listepr3_inserer(listepr3 * _p, ptrpr3 * _i, double _x, double _y, double _z)
{
	listepr3_inserer_apres(_p, _i, _x, _y, _z);
}


void listepr3_supprimer_tete(listepr3 * _p)
{
	ptrpr3 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		if(_p->tete == _p->queue)
		{
			_p->tete  = NULL;
			_p->queue = NULL;
		}
		else
			_p->tete = p->suivant;
		
		free(p);
	}
}


void listepr3_supprimer_queue(listepr3 * _p)
{
	ptrpr3 * p;
	
	p = _p->tete;
	if(p)
	{
		_p->nPoints--;
	
		while(p->suivant != _p->queue)
			p = p->suivant;
		
		free(_p->queue);
		
		p->suivant = NULL;
		_p->queue = p;
	}
}


void listepr3_supprimer(listepr3 * _p, ptrpr3 * _i)
{
	ptrpr3 * p, * q;
	
	if(_i == _p->tete)
		listepr3_supprimer_tete(_p);
	else
	{
		if(_i == _p->queue)
			listepr3_supprimer_queue(_p);
		else
		{
			_p->nPoints--;

			p = _p->tete;
			while(p->suivant != _i)
				p = p->suivant;
			
			q = p->suivant;
			p->suivant = q->suivant;
			free(q);
		}
	}
}


void listepr3_vider(listepr3 * _p)
{
	while(_p->tete)
		listepr3_supprimer_tete(_p);
}


void listepr3_copier(listepr3 * _p, listepr3 * _q)
{
	ptrpr3 * p;
	
	p = _p->tete;
	while(p)
	{
		listepr3_ajouter(_q, p->coords[0], p->coords[1], p->coords[2]);
		
		p = p->suivant;
	}
}


void listepr3_trier(listepr3 * _p, int (* _f)(ptrpr3 *, ptrpr3 *))
{
	ptrpr3 * p, * q;
	double tmp;

	if(_f == NULL)
		return;
		
	p = _p->tete;
	while(p)
	{
		q = p;
		while(q)
		{
			if((*_f)(p, q) > 0)
			{
				tmp  		 = p->coords[0];
				p->coords[0] = q->coords[0];
				q->coords[0] = tmp;
				
				tmp  		 = p->coords[1];
				p->coords[1] = q->coords[1];
				q->coords[1] = tmp;
				
				tmp  		 = p->coords[2];
				p->coords[2] = q->coords[2];
				q->coords[2] = tmp;
			}
			
			q = q->suivant;
		}
	
		p = p->suivant;
	}
}


ptrpr3 * listepr3_rechercher(listepr3 * _p, double _x, double _y, double _z, double _t)
{
	ptrpr3 * p;
	
	if(_p == NULL)
		return NULL;
	
	p = _p->tete;
	while(p)
	{
		if(fabs(_x - p->coords[0]) <= _t && fabs(_y - p->coords[1]) <= _t && fabs(_z - p->coords[2]) <= _t)
			return p;
			
		p = p->suivant;
	}
	
	return NULL;
}


void listepr3_afficher(listepr3 * _p)
{
	ptrpr3 * p;
	
	p = _p->tete;
	while(p)
	{
		printf("(%f, %f, %f) ", p->coords[0], p->coords[1], p->coords[2]);
		p = p->suivant;
	}	
	
	printf("\n");
}
