#include "thread.h"


MyThread::MyThread(Fenetre *f, int ID)  : wxThread()
{
    frame = f;
	dimension = -1;
	indice = -1;
	path = "";
	fichier = "";
	sequence = false;
	action = ID;
}


MyThread::MyThread(Fenetre *f)
{
	MyThread(f,ID_UNKNOW);
}


void MyThread::setAction (int ID)
{
	action = ID;
}


void *MyThread::Entry()
{
	wxString ligne;
	
	if (action == ID_UNKNOW)
	{
		cout << "[Thread] Action non communique.\n";
		return NULL;
	}
	
	frame->m_statbarLoading->timer_progressBar.Start(100);
	
	
	/* ligne  crire dans le script */
	if (action == ID_OPEN)
		ligne = wxString::Format(_T("Charger fichier RAW %d %d\n"), (sequence)?1:0, indice);
	else if (action == ID_SAVE)
		ligne = wxString(string("Sauvegarder fichier RAW " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_TOOL_GAUSSIEN)
		ligne = wxString::Format(_T("Appliquer filtre gaussien %dD"), dimension);
	else if (action == ID_TOOL_CONTOUR)
		ligne = wxString::Format(_T("Extraire contour %dD"), dimension);
	else if (action == ID_TOOL_DILATATION)
		ligne = wxString::Format(_T("Appliquer dilatation %dD"), dimension);
	else if (action == ID_TOOL_EROSION)
		ligne = wxString::Format(_T("Appliquer erosion %dD"), dimension);
	else if (action == ID_TOOL_OUVERTURE)
		ligne = wxString::Format(_T("Appliquer ouverture %dD"), dimension);
	else if (action == ID_TOOL_FERMETURE)
		ligne = wxString::Format(_T("Appliquer fermeture %dD"), dimension);
	else if (action == ID_TOOL_SUPPRESS)
		ligne = wxString::Format(_T("Appliquer suppression parasites %dD"), dimension);
	else if (action == ID_TOOL_CONVERTIR)
		ligne = wxString::Format(_T("Convertir 8bits %dD"), dimension);
	else if (action == ID_APPLIQUER_INVERSION)
		ligne = wxString::Format(_T("Appliquer fonction inversion %dD"), dimension);
	else if (action == ID_APPLIQUER_CARREE)
		ligne = wxString::Format(_T("Appliquer fonction carree %dD"), dimension);
	else if (action == ID_APPLIQUER_EXP)
		ligne = wxString::Format(_T("Appliquer fonction exponentielle %dD"), dimension);
	else if (action == ID_APPLIQUER_LOG)
		ligne = wxString::Format(_T("Appliquer fonction logarithmique %dD"), dimension);
	else if (action == ID_TOOL_BINARISER)
		ligne = wxString::Format(_T("Appliquer binarisation %d-%d %dD"), frame->slide_seuilmin->GetValue(), frame->slide_seuilmax->GetValue(), dimension);
	else if (action == ID_MENU_EXECSCRIPT)
		ligne = _T("Executer script ./.tmp");
	else if (action == ID_MENU_IMPORT_DV)
		ligne = wxString(string("Charger fichier DV " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_MENU_IMPORT_3D)
		ligne = wxString(string("Charger fichier 3D " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_MENU_IMPORT_OBJ)
		ligne = wxString(string("Charger fichier OBJ " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_MENU_EXPORT_DV)
		ligne = wxString(string("Sauvegarder fichier DV " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_MENU_EXPORT_3D)
		ligne = wxString(string("Sauvegarder fichier 3D " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_MENU_EXPORT_OBJ)
		ligne = wxString(string("Sauvegarder fichier OBJ " + path + " " + fichier + "\n").c_str(), wxConvUTF8);
	else if (action == ID_TOOL_CONVERSION3D)
		ligne = wxString::Format(_T("Convertir OBJ %dD"), dimension);
	else if (action == ID_TOOL_SUPPRESS)
		ligne = wxString::Format(_T("Appliquer suppression parasites %dD"), dimension);
	
	if (action!=ID_OPEN && action!=ID_SAVE && action!=ID_MENU_EXECSCRIPT && !(action>ID_MENU_IMPORT_DEBUT && action<ID_MENU_EXPORT_FIN))
	{
		/* ajout des variables suivant la dimension */
		if (dimension == DIM_2D)
			ligne += wxString::Format(_T(" (%d,%d)\n"), frame->moment, frame->vue2d->getHauteurCoupe());
		else if (dimension == DIM_3D)
			ligne += wxString::Format(_T(" (%d)\n"), frame->moment);
		else if (dimension == DIM_4D)
			ligne += _T("\n");
	}
	
	
	/* ajout au script et lancement de la commande */
	frame->miniscript->AppendText(ligne);
	script::traiterLigne(string((ligne).mb_str(wxConvLibc)), &frame->coeur, &frame->m_statbarLoading->positionProgressBar);
	
	frame->m_statbarLoading->state = 1;
	return NULL;
}


void MyThread::OnExit()
{
}


void MyThread::setPath (string p)
{
	path = p;
}


void MyThread::setFichier (string f)
{
	fichier = f;
}


void MyThread::setDimension (int d)
{
	dimension = d;
}


void MyThread::setIndice (int i)
{
	indice = i;
}


void MyThread::ouvertureSequence (bool s)
{
	sequence = s;
}
