#include "statusBarChargement.h"
#include <wx/colour.h>


BEGIN_EVENT_TABLE(statusBarChargement, wxStatusBar)
	EVT_TIMER(wxID_ANY, statusBarChargement::OnTimer)
    EVT_SIZE(statusBarChargement::OnSize)
END_EVENT_TABLE()


statusBarChargement::statusBarChargement(Fenetre *parent, int ID) : wxStatusBar(parent, wxID_ANY), timer_progressBar(this)
{
	creer(parent, ID);
}


statusBarChargement::statusBarChargement(Fenetre *parent) : wxStatusBar(parent, wxID_ANY), timer_progressBar(this)
{
	creer(parent, ID_UNKNOW);
}


void statusBarChargement::OnSize (wxSizeEvent& WXUNUSED(evt))
{
    wxRect rect;
    GetFieldRect(2, rect);
    gauge_chargement->SetSize(rect.x - 10, rect.y - 10, rect.width - 20, rect.height - 20);
    wxSize size = gauge_chargement->GetSize();
    gauge_chargement->Move(rect.x + (rect.width - size.x) / 2, rect.y + (rect.height - size.y) / 2);
	
	Refresh();
}


void statusBarChargement::creer (Fenetre *parent, int ID)
{
	frame = parent;
	state = -1;
	action = ID;
	dimension = -1;

    SetFieldsCount(3);
	timer_progressBar.SetOwner(this, -1);

	gauge_chargement = new wxGauge (this,2,-1, wxDefaultPosition, wxSize(100, 15));
	gauge_chargement->SetForegroundColour(wxColour(255,0,0));
	positionProgressBar = 0;
    SetMinHeight(20);
}


void statusBarChargement::setAction (int ID)
{
	action = ID;
}


void statusBarChargement::setDimension (int d)
{
	dimension = d;
}


statusBarChargement::~statusBarChargement()
{
    if (timer_progressBar.IsRunning())
        timer_progressBar.Stop();
}


void statusBarChargement::OnTimer(wxTimerEvent& WXUNUSED(event))
{
	/* premier passage dans le timer */
	if (state == -1)
	{
		/* on dfinit la taille de la gauge */
		if (action==ID_OPEN || action==ID_SAVE)
		{
			gauge_chargement->SetRange(frame->coeur.getDuree() * frame->coeur.getNombreImage());
			gauge_chargement->SetValue(0);
			positionProgressBar = 0;
			state = 0;
		}
		else if (action==ID_TRAITEMENT || action==ID_TRAITEMENT_2)
		{
			int lg = 0;
			
			if (dimension == DIM_2D)
				lg = 1;
			else if (dimension == DIM_3D)
				lg = frame->coeur.getNombreImage();
			else if (dimension == DIM_4D)
				lg = frame->coeur.getDuree() * frame->coeur.getNombreImage();
			
			if (action == ID_TRAITEMENT_2)
				lg *= 2;
			
			gauge_chargement->SetRange(lg);
			gauge_chargement->SetValue(0);
			positionProgressBar = 0;
			state = 0;
		}
		else if (action == ID_SCRIPT)
		{
			gauge_chargement->SetRange(dimension);
			gauge_chargement->SetValue(0);
			positionProgressBar = 0;
			state = 0;
		}
		else if (action == ID_OBJ)
		{
			/* on ajoute 3 pour la sauvegarde du fichier OBJ */
			gauge_chargement->SetRange(volume::RESOLUTION_SURFACES_IMPLICITES + 3);
			gauge_chargement->SetValue(0);
			positionProgressBar = 0;
			state = 0;
		}
		else
			gauge_chargement->SetRange(0);
	}
	
	/* chargement en cours */
	if (state == 0)
	{
		/* avancement de la gauge */
		gauge_chargement->SetValue(positionProgressBar);
	}
	/* chargement termin */
	else if (state > 0)
	{
		/* on arrte le timer */
		timer_progressBar.Stop();
		gauge_chargement->SetValue(0);
		positionProgressBar = 0;
		
		if (action==ID_OPEN || action==ID_SCRIPT || action==ID_OBJ)
		{
			/* on change les seuils suivant l'image charge */
			frame->miseAJour(INIT_HAUTEUR);
			frame->miseAJour(INIT_SEUIL);
			frame->miseAJour(INIT_HISTO);
			/* on active l'nterface */
			frame->barre_menu->Enable(true);
			if (!frame->coeur.isEmpty())
				frame->vue2d->actif();
			
			frame->activerMenus(dimension);
			
			if (action==ID_OBJ)
			{
				frame->vue2d->chargerObj(".obj");
				frame->vue2d->setAffichageObj();
			}
			else
				frame->vue2d->setAffichageImg();
		}
		
		if (action == ID_SCRIPT)
			remove(".tmp");
		
		state = -1;
		action = ID_UNKNOW;
		frame->miseAJour(INIT_SEUIL);
		frame->miseAJour(MAJ_HISTO);
		
		frame->Refresh(true);
	}
}
