#include "popupMenu.h"
#include "mainframe.h"


BEGIN_EVENT_TABLE(popupMenu,wxPopupTransientWindow)
    EVT_MOUSE_EVENTS	( popupMenu::OnMouse )
    EVT_SIZE			( popupMenu::OnSize )
    EVT_SET_FOCUS		( popupMenu::OnSetFocus )
    EVT_KILL_FOCUS		( popupMenu::OnKillFocus )
END_EVENT_TABLE()


popupMenu::popupMenu (Fenetre *parent) : wxPopupTransientWindow (parent)
{
	frame = parent;
    panel = new wxScrolledWindow (this, wxID_ANY);	
    panel->Connect(wxEVT_MOTION, wxMouseEventHandler(popupMenu::OnMouse), NULL, this);
	
    sizer = new wxBoxSizer (wxVERTICAL);
}


popupMenu::~popupMenu()
{
}


void popupMenu::ajoutLien (wxString titre, int id)
{
	wxButton *bouton = new wxButton(panel, id, titre);
    sizer->Add(bouton, 0, wxALL | wxEXPAND, 5);
	bouton->Connect (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(popupMenu::OnButton), NULL, this);
}


void popupMenu::finAjout ()
{
    panel->SetAutoLayout(true);
    panel->SetSizer(sizer);
    sizer->Fit(panel);
    sizer->Fit(this);
}


void popupMenu::Popup(wxWindow *focus)
{
    wxPopupTransientWindow::Popup(focus ? focus : panel);
}


void popupMenu::OnDismiss()
{
    wxPopupTransientWindow::OnDismiss();
}


bool popupMenu::ProcessLeftDown(wxMouseEvent& event)
{
    return wxPopupTransientWindow::ProcessLeftDown(event);
}


bool popupMenu::Show( bool show )
{
    return wxPopupTransientWindow::Show(show);
}


void popupMenu::OnSize(wxSizeEvent &event)
{
    event.Skip();
}


void popupMenu::OnSetFocus(wxFocusEvent &event)
{
    event.Skip();
}


void popupMenu::OnKillFocus(wxFocusEvent &event)
{
    event.Skip();
}


void popupMenu::OnMouse(wxMouseEvent &event)
{
    event.Skip();
}


void popupMenu::OnButton(wxCommandEvent& event)
{
	Close();
	frame->OnLancerThread(event);
    event.Skip();
}
