#include "panelOpenGL3d.h"
#include "mainframe.h"


BEGIN_EVENT_TABLE (panelOpenGL3d, wxGLCanvas)
	EVT_MOTION		(panelOpenGL3d::mouseMoved)
	EVT_LEFT_DOWN	(panelOpenGL3d::mouseUpOrDown)
	EVT_LEFT_UP		(panelOpenGL3d::mouseUpOrDown)
	EVT_MOUSEWHEEL	(panelOpenGL3d::mouseWheelMoved)
	
	EVT_PAINT		(panelOpenGL3d::affichageParam)
	EVT_SIZE		(panelOpenGL3d::resizeParam)
END_EVENT_TABLE()


void panelOpenGL3d::mouseMoved(wxMouseEvent &event)
{
	if (!initialisationGL)
	{
		if (event.Dragging())
		{
			tbMotion (event.GetX(), event.GetY());
			Refresh();
		}
	}
}


void panelOpenGL3d::mouseUpOrDown(wxMouseEvent &event)
{
	if (!initialisationGL)
	{
		int state, button;
		
		button = -1;
		state = -1;
		
		if (event.GetButton() == 1)
		{
			button = GLUT_LEFT_BUTTON;
			state = event.LeftIsDown()?GLUT_DOWN:GLUT_UP;
		}
		else if (event.GetButton() == 2)
		{
			button = GLUT_MIDDLE_BUTTON;
			state = event.MiddleIsDown()?GLUT_DOWN:GLUT_UP;
		}
		else if (event.GetButton() == 3)
		{
			button = GLUT_RIGHT_BUTTON;
			state = event.RightIsDown()?GLUT_DOWN:GLUT_UP;
		}
		
		tbMouse (button, state, event.GetX(), event.GetY());
		Refresh();
	}
}


void panelOpenGL3d::mouseWheelMoved(wxMouseEvent& event)
{
	if (!initialisationGL)
	{
		if (event.GetWheelRotation() > 0)
			zoom+=.1;
		else
			zoom-=.1;
	}
	
	Refresh();
}

	
panelOpenGL3d::panelOpenGL3d (wxWindow *parent, Fenetre *f, wxSize size) : wxGLCanvas(parent, wxID_ANY,  wxDefaultPosition, size, 0, wxT("GLCanvas"))
{
	frame = f;
	listeGL = 0;
	profondeur = 16;
	fichierObj = NULL;
	initialisationGL = true;
}


panelOpenGL3d::~panelOpenGL3d()
{
}


void panelOpenGL3d::affichageParam (wxPaintEvent& WXUNUSED(event))
{
	wxPaintDC dc(this);
	affichage();
}


void panelOpenGL3d::affichage ()
{
	SetCurrent();
	
	if (initialisationGL)
	{
		GLfloat specular[] 	= { 0.5, 0.5, 0.5, 1.0 };
		GLfloat ambient [] 	= { 0.3, 0.3, 0.3      };
		GLfloat position[] 	= { 0.0, 0.0, 2.0, 1.0 };
		
		glClearColor(0.5, 0.5, 0.5, 1.0);
		
		glLightfv(GL_LIGHT0, GL_SPECULAR, specular);
		glLightfv(GL_LIGHT0, GL_POSITION, position);
		glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
		
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		glEnable(GL_LIGHTING);
		glEnable(GL_LIGHT0);
		
		tbInit(GLUT_LEFT_BUTTON);
		tbAnimate(GL_TRUE);
		zoom = 1.0;
		
		tbReshape(GetSize().x, GetSize().y);
		glViewport(0, 0, GetSize().x, GetSize().y);
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(60, (GLfloat)GetSize().y/(GLfloat)GetSize().y, 0.1, 128.0);
			
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		gluLookAt(0.0, 1.0, zoom, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
		
		initialisationGL = false;
	}
	
	
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	gluLookAt(0.0, 1.0, zoom, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
	GLfloat mat_amb[] = { 0.2, 0.2, 0.2, 1.0 };
	GLfloat mat_dif[] = { 0.7, 0.5, 0.5, 1.0 };
	GLfloat mat_spe[] = { 0.2, 0.2, 0.0, 1.0 };
	
	glPushMatrix();
		tbMatrix();
		
		glMaterialfv(GL_FRONT_AND_BACK, GL_AMBIENT,   mat_amb);
		glMaterialfv(GL_FRONT_AND_BACK, GL_DIFFUSE,   mat_dif);
		glMaterialfv(GL_FRONT_AND_BACK, GL_SPECULAR,  mat_spe);
		glMaterialf (GL_FRONT_AND_BACK, GL_SHININESS, 0);
		
		if (listeGL != 0)
			glCallList(listeGL);
	glPopMatrix();
	
	glFlush();
	SwapBuffers();
}


void panelOpenGL3d::resizeParam (wxSizeEvent& event)
{
	wxGLCanvas::OnSize(event);
	resize();
	Refresh();
}


void panelOpenGL3d::resize ()
{
	SetCurrent();
	initialisationGL = true;
}


void panelOpenGL3d::chargerObj (string nomFichier)
{
	if (fichierObj)
		delete fichierObj;
	
	fichierObj = new obj();
	fichierObj->charger(nomFichier.c_str());
	fichierObj->normaliser();
	creerListeGL();
}


void panelOpenGL3d::creerListeGL ()
{
	int ptCourant;
	pt tmp;
	vector<uint> enCours;
	
	if (listeGL != 0)
		glDeleteLists(listeGL, 1);
	
	listeGL = glGenLists(1);
	glNewList(listeGL, GL_COMPILE);
		if (fichierObj)
		{			
			for (unsigned int i=0; i!=fichierObj->face.size(); i++)
			{
				enCours = fichierObj->face.at(i);
				
				glBegin(GL_POLYGON);
				for (unsigned int j=0; j!=enCours.size(); j++)
				{
					ptCourant = enCours.at(j);
					
					tmp = fichierObj->normale.at(ptCourant);
					glNormal3f(tmp.x, tmp.y, tmp.z);
					
					tmp = fichierObj->point.at(ptCourant);
					glVertex3f(tmp.x, tmp.y, tmp.z);
				}
				glEnd();
			}
		}
	glEndList();
}
