#include "panelOpenGL2d.h"
#include "mainframe.h"


BEGIN_EVENT_TABLE (panelOpenGL2d, wxGLCanvas)
	EVT_PAINT	(panelOpenGL2d::affichageParam)
	EVT_SIZE	(panelOpenGL2d::resizeParam)
END_EVENT_TABLE()


panelOpenGL2d::panelOpenGL2d (wxWindow *parent, Fenetre *f, wxSize size) : wxGLCanvas(parent, wxID_ANY,  wxDefaultPosition, size, 0, wxT("GLCanvas"))
{
	frame = f;
	hauteurCoupe = 0;
}


panelOpenGL2d::~panelOpenGL2d()
{
}


void panelOpenGL2d::affichageParam (wxPaintEvent& WXUNUSED(event))
{
	wxPaintDC dc(this);
	affichage();
}


void panelOpenGL2d::affichage ()
{
	wxPaintDC(this);
	SetCurrent();
	
	glClearColor(0,0,0,1);
	glClear(GL_COLOR_BUFFER_BIT);
	
	if (frame && frame->coeur.isValide())
	{
		unsigned char *img = frame->coeur.getImage(frame->moment,hauteurCoupe);
		
		if (img != NULL)
		{
			float rapport;
			/* calcul du coeff multiplicateur pour que l'image soit la plus grande possible */
			rapport = (float)GetSize().x / frame->coeur.getLargeur();
			if (((float)GetSize().y / frame->coeur.getHauteur()) < rapport)
				rapport = (float)GetSize().y / frame->coeur.getHauteur();
			
			/* affichage */
			glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
			glMatrixMode(GL_PROJECTION);
			glViewport(0,0,(GLint)GetSize().x, (GLint)GetSize().y);
			glLoadIdentity();
			gluOrtho2D(0, frame->coeur.getLargeur(), 0, frame->coeur.getHauteur());
			glMatrixMode(GL_MODELVIEW);
			glLoadIdentity();
			
			glPixelZoom (rapport, rapport);
			glDrawPixels(frame->coeur.getLargeur(), frame->coeur.getHauteur(), GL_LUMINANCE, GL_UNSIGNED_BYTE, img);
		}
	}
	
	glFlush();
	SwapBuffers();
}


void panelOpenGL2d::resizeParam (wxSizeEvent& event)
{
	wxGLCanvas::OnSize(event);
	resize();
	Refresh();
}


void panelOpenGL2d::resize ()
{
}
