#include "miniFrame.h"
#include "mainframe.h"

#include <wx/artprov.h>
#include "bitmaps/moins.xpm"
#include "bitmaps/plus.xpm"
/*
 * Partie concernant une miniframe
 */
 
BEGIN_EVENT_TABLE (miniFrame, wxMiniFrame)
    EVT_PAINT	(miniFrame::OnPaint)
    EVT_CLOSE 	(miniFrame::OnCloseWindow)
    EVT_SIZE	(miniFrame::OnSize)
END_EVENT_TABLE()


miniFrame::miniFrame(wxFrame* parent, wxWindowID id, const wxString &title, const wxPoint &pos, const wxSize &size, bool resizable)
	: wxMiniFrame(parent, id, title, pos, size, (resizable)?wxCAPTION|wxCLOSE_BOX|wxRESIZE_BORDER:wxCAPTION|wxCLOSE_BOX)
{
	auiManager.SetManagedWindow(this);
}


void miniFrame::OnPaint (wxPaintEvent& WXUNUSED(evt))
{
	auiManager.Update();
	
}


void miniFrame::OnCloseWindow (wxCloseEvent& WXUNUSED(event))
{
	Hide();
}


void miniFrame::OnSize(wxSizeEvent& WXUNUSED(evt))
{
	Refresh();
}







/*
 * Partie concernant l'affichage de l'histogramme
 */
 
BEGIN_EVENT_TABLE (affHisto, wxGLCanvas)
	EVT_PAINT	(affHisto::affichageParam)
	EVT_SIZE	(affHisto::resizeParam)
END_EVENT_TABLE()


affHisto::affHisto (wxFrame *parent, Fenetre *f, const wxSize &size)
	: wxGLCanvas(parent, wxID_ANY,  wxDefaultPosition, size, 0, wxT("GLCanvas"))
{
	frame = f;
	largeurHisto = 0;
	hauteurHisto = 0;
	seuilMin = 0;
	seuilMax = 0;
	
	vol = NULL;
	ech = NULL;
	zoom = 1.0;
	
	btn_zoomMoins = new wxBitmapButton (this, wxID_ANY, wxBITMAP(moins), wxDefaultPosition, wxSize(20,20), wxBU_EXACTFIT);
	btn_zoomPlus  = new wxBitmapButton (this, wxID_ANY, wxBITMAP(plus), wxDefaultPosition, wxSize(20,20), wxBU_EXACTFIT);
	btn_zoomMoins->Connect	( wxEVT_COMMAND_BUTTON_CLICKED,		wxCommandEventHandler	(affHisto::OnZoomMoins), NULL, this );
	btn_zoomPlus->Connect	( wxEVT_COMMAND_BUTTON_CLICKED,		wxCommandEventHandler	(affHisto::OnZoomPlus),  NULL, this );
}


affHisto::~affHisto()
{
	if (ech != NULL)
		delete [] ech;
	
	vol = NULL;
}


void affHisto::affichageParam (wxPaintEvent& WXUNUSED(event))
{
	wxPaintDC dc(this);
	affichage();
}


void affHisto::affichage ()
{
	wxPaintDC(this);
	SetCurrent();
	
	int espace = 5;
	glViewport(espace,espace,(GLint)GetSize().x-2*espace, (GLint)GetSize().y-2*espace);
	glClearColor(1,1,1,1);
	glClear(GL_COLOR_BUFFER_BIT);
	
	
	if (vol != NULL)
	{
		/* affichage */
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluOrtho2D(0, largeurHisto, 0, hauteurHisto);
		glRasterPos2i(0, 0);
        glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		
		glBegin(GL_LINES);
		glColor3f(0.0,0.0,1.0);
			/* axe des x */
			glVertex2i (0, 0);
			glVertex2i (largeurHisto, 0);
		glColor3f(1.0,0.0,0.0);
			/* axe des y */
			glVertex2i (0, 0);
			glVertex2i (0, hauteurHisto);
		glEnd();
		
		glColor3f(1.0,0.0,0.0);
		glBegin(GL_LINES);
			/* premire partie : 0->seuilMin */
			for (int i=0; i<seuilMin; i++)
			{
				glVertex2i (i, 0);
				glVertex2i (i, (int)(ech[i]*zoom));
			}
		glEnd();
			
		glColor3f(0.0,0.0,0.0);
		glBegin(GL_LINES);
			/* seconde partie : seuilMin->seuilMax */
			for (int i=seuilMin; i<seuilMax; i++)
			{
				glVertex2i (i, 0);
				glVertex2i (i, (int)(ech[i]*zoom));
			}
		glEnd();
		
		glColor3f(0.0,0.0,1.0);
		glBegin(GL_LINES);
			/* troisime partie : seuilMin->fin */
			for (int i=seuilMax; i<largeurHisto; i++)
			{
				glVertex2i (i, 0);
				glVertex2i (i, (int)(ech[i]*zoom));
			}
		glEnd();
		
		glPixelZoom (1, 1);
	}
	
	btn_zoomMoins->Refresh();
	btn_zoomPlus->Refresh();
	glFlush();
	SwapBuffers();
}


void affHisto::resizeParam (wxSizeEvent& event)
{
	wxGLCanvas::OnSize(event);
	resize();
	wxSize s = GetSize();
	btn_zoomMoins->SetPosition(wxPoint(s.x - 65,20));
	btn_zoomPlus->SetPosition(wxPoint(s.x - 40,20));
	Refresh();
}


void affHisto::resize ()
{
}


void affHisto::setImage (int num)
{
	if (vol == NULL)
		return;
	
	largeurHisto = vol->getValeurMaximale(num)+1;
	hauteurHisto = 0;
	
	if (ech!=NULL)
	{
		delete [] ech;
		ech = NULL;
	}
	
	if (!ech)
	{
		try
		{
			ech = new int [vol->getValeurMaximale(num)+1];
		} 
		catch(bad_alloc ex)
		{
			cerr << "[-] affHisto::setImage > " << ex.what() << '\n';
			exit(0); 
		}
	}
	
	/* tableau initialis  0 */
	for (int i=0; i!=largeurHisto; i++)
		ech[i] = 0;
	
	for (int i=0; i!=vol->getLargeur(); i++)
		for (int j=0; j!=vol->getHauteur(); j++)
			ech[(int)vol->getValeurPixel(num,i,j)]++;
	
	for (int i=0; i!=largeurHisto; i++)
		if (hauteurHisto < ech[i])
			hauteurHisto = ech[i];
	
	seuilMin = frame->slide_seuilmin->GetValue();
	seuilMax = frame->slide_seuilmax->GetValue();
	
	Refresh(true);
}


void affHisto::setVolume (volume *v, int num)
{
	if (v != NULL)
	{
		vol = v;
		setImage(num);
	}
}


void affHisto::OnZoomMoins (wxCommandEvent &WXUNUSED(event))
{
	if (zoom > 1)
		zoom-=0.5;
	
	Refresh();
}


void affHisto::OnZoomPlus (wxCommandEvent &WXUNUSED(event))
{
	zoom+=0.5;
	Refresh();
}
