#ifndef MAINFRAME_H
#define MAINFRAME_H


/* include c++ */
using namespace std;
#include <iostream>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


/* includes wxWidget */
#include <wx/wx.h>
#include <wx/glcanvas.h>
#include <wx/gauge.h>
#include <wx/thread.h>
#include <wx/treectrl.h>
#include <wx/aui/aui.h>
#include <wx/wxprec.h>
#include <wx/spinctrl.h>
#include <wx/aboutdlg.h>

class Fenetre;
class statusBarChargement;
class popupMenu;
/* includes programme */
#include "panelOpenGL3d.h"
#include "thread.h"
#include "miniFrame.h"
#include "frame2d.h"
#include "sequence.h"
#include "statusBarChargement.h"
#include "popupMenu.h"
#include "loading.h"
#include "elementStruct.h"
#include "script.h"


/* define utilis pour savoir quelle mise a jour il faut faire */
#define INIT_SEUIL					  0
#define INIT_HISTO					  1
#define INIT_HAUTEUR				  2
#define MAJ_SEUIL					  3
#define MAJ_HISTO					  4
#define MAJ_MENUCHECK				 10


/* define permettant de spcifier ce que doit faire le thread */
/* (utilis aussi par la barre de progression) */
#define		ID_UNKNOW				 -1
#define		ID_OPEN					  0
#define		ID_SAVE					  1
#define		ID_TRAITEMENT			  2
#define		ID_TRAITEMENT_2			  3 /* traitement deux fois plus long (ex. ouverture) */
#define		ID_SCRIPT    			  4
#define		ID_OBJ	    			  5


/* define timer */
#define ID_TIMER					  0
/* define des identifiants du menu fichier */
#define ID_MENU_OUVRIR_VOL			  1
#define ID_MENU_OUVRIR_SEQ			  2
#define ID_MENU_EXPORT_NUAGE		  4
#define ID_MENU_LOADSCRIPT			  5
#define ID_MENU_EXECSCRIPT			  6
#define ID_MENU_SAVESCRIPT			  7
#define ID_MENU_SAUVE_SEQ			  3
#define ID_MENU_QUITTER				  9
#define ID_MENU_IMPORT_DEBUT		 19
#define ID_MENU_IMPORT_DV			 20
#define ID_MENU_IMPORT_3D			 21
#define ID_MENU_IMPORT_OBJ			 22
#define ID_MENU_IMPORT_FIN			 29
#define ID_MENU_EXPORT_DEBUT		 ID_MENU_IMPORT_FIN
#define ID_MENU_EXPORT_DV			 30
#define ID_MENU_EXPORT_3D			 31
#define ID_MENU_EXPORT_OBJ			 32
#define ID_MENU_EXPORT_FIN			 39
/* define des identifiants de la tool bar (commun) */
#define ID_TOOL_HISTOGRAMME			 50
#define ID_TOOL_FUNCTION			 51
#define ID_TOOL_SCRIPT  			 52
/* define des identifiants de la tool bar */
#define ID_TOOL_SEUILLAGE			100
#define ID_APPLIQUER_INVERSION		101
#define ID_APPLIQUER_CARREE			102
#define ID_APPLIQUER_EXP			103
#define ID_APPLIQUER_LOG			104
#define ID_TOOL_GAUSSIEN			105
#define ID_TOOL_DILATATION			106
#define ID_TOOL_EROSION				107
#define ID_TOOL_OUVERTURE			108
#define ID_TOOL_FERMETURE			109
#define ID_TOOL_SUPPRESS			110
#define ID_TOOL_CONTOUR				111
#define ID_TOOL_CONVERTIR           112
#define ID_TOOL_BINARISER           113
#define ID_TOOL_CONVERSION3D		114
/* define des identifiants du menu 2d */
#define ID_TOOL_SEUILLAGE_2D		200
#define ID_APPLIQUER_INVERSION_2D	201
#define ID_APPLIQUER_CARREE_2D		202
#define ID_APPLIQUER_EXP_2D			203
#define ID_APPLIQUER_LOG_2D			204
#define ID_TOOL_GAUSSIEN_2D			205
#define ID_TOOL_DILATATION_2D		206
#define ID_TOOL_EROSION_2D			207
#define ID_TOOL_OUVERTURE_2D		208
#define ID_TOOL_FERMETURE_2D		209
#define ID_TOOL_SUPPRESS_2D			210
#define ID_TOOL_CONTOUR_2D			211
#define ID_TOOL_CONVERSION3D_2D		214
#define ID_TOOL_DEFAULT_2D			299
/* define des identifiants du menu 3d */
#define ID_TOOL_SEUILLAGE_3D		300
#define ID_APPLIQUER_INVERSION_3D	301
#define ID_APPLIQUER_CARREE_3D		302
#define ID_APPLIQUER_EXP_3D			303
#define ID_APPLIQUER_LOG_3D			304
#define ID_TOOL_GAUSSIEN_3D			305
#define ID_TOOL_DILATATION_3D		306
#define ID_TOOL_EROSION_3D			307
#define ID_TOOL_OUVERTURE_3D		308
#define ID_TOOL_FERMETURE_3D		309
#define ID_TOOL_SUPPRESS_3D			310
#define ID_TOOL_CONTOUR_3D			311
#define ID_TOOL_CONVERSION3D_3D		314
#define ID_TOOL_DEFAULT_3D			399
/* define des identifiants du menu 4d */
#define ID_TOOL_SEUILLAGE_4D		400
#define ID_APPLIQUER_INVERSION_4D	401
#define ID_APPLIQUER_CARREE_4D		402
#define ID_APPLIQUER_EXP_4D			403
#define ID_APPLIQUER_LOG_4D			404
#define ID_TOOL_GAUSSIEN_4D			405
#define ID_TOOL_DILATATION_4D		406
#define ID_TOOL_EROSION_4D			407
#define ID_TOOL_OUVERTURE_4D		408
#define ID_TOOL_FERMETURE_4D		409
#define ID_TOOL_SUPPRESS_4D			410
#define ID_TOOL_CONTOUR_4D			411
#define ID_TOOL_CONVERSION3D_4D		414
#define ID_TOOL_DEFAULT_4D			499
/* define parametre */
#define ID_MENU_RES8				500
#define ID_MENU_RES16				501
#define ID_MENU_RES32				502
#define ID_MENU_RES64				503
#define ID_MENU_RES128				504
/* define des identifiants du menu about */
#define ID_MENU_ABOUT				600
/* define des boutons */
#define ID_BUTTON_SEUILMINMOINS		 90
#define ID_BUTTON_SEUILMINPLUS		 91
#define ID_BUTTON_SEUILMAXMOINS		 92
#define ID_BUTTON_SEUILMAXPLUS		 93
#define ID_BUTTON_SEUILLER			 94
#define ID_BUTTON_BINARISER			 95


class Fenetre : public wxFrame
{
	public:
		/* constructeur */
							Fenetre						(const wxString& title, const wxPoint& pos, const wxSize& size, long style = wxDEFAULT_FRAME_STYLE);
		/* vnement fenetre */
		void				OnSize						(wxSizeEvent &event);
	    void				OnClose						(wxCloseEvent& event);	
		/* vnements du menu */
		void				OnMenuOuvrir				(wxCommandEvent &event);
		void				OnMenuExportNuage			(wxCommandEvent &event);
		void				OnMenuSave					(wxCommandEvent &event);
		void				OnMenuScript				(wxCommandEvent &event);
		void				OnMenuConversion3D			(wxCommandEvent &event);
		void				OnFonction					(wxCommandEvent &event);
		void 				OnMenuQuitter				(wxCommandEvent &event);
		void				OnAbout						(wxCommandEvent &event);
		void				OnChangementResolution		(wxCommandEvent &event);
		/* vnements miniFrame */
		void				OnOpenSeuillage				(wxCommandEvent &event);
		void 				OnSlideMinMove				(wxScrollEvent &event);
		void 				OnSlideMaxMove				(wxScrollEvent &event);
		void 				OnSpinSeuilMin				(wxSpinEvent &event);
		void 				OnSpinSeuilMax				(wxSpinEvent &event);
		void				OnSeuiller					(wxCommandEvent &event);
		void				OnBinarisation				(wxCommandEvent &event);
		void				OnOpenHistogramme			(wxCommandEvent &event);
		void				OnOpenScript    			(wxCommandEvent &event);
		void				OnLancerThread				(wxCommandEvent &event);
		void				OnDefault					(wxCommandEvent &event);
		
		/* autres fonctions */
		void 				MaJimage 					(int temps, int hauteurCoupe);
		void				miseAJour					(int choix);
		void                activerMenus                (int dimension = DIM_3D);
		void                desactiverMenus             (int dimension = DIM_3D);
		void                affichageMenus              (int dimension, bool afficher);
		void				creerSeuillage				(bool visible);
		void				creerHistogramme			(bool visible);
		void				creerScript					(bool visible);		
		void                ajouterScript               (wxString s);
		
		sequence			coeur;
		int					moment;
		
		bool 				affichageOk;
		wxToolBar			*barre_menu;
		frame2d		 		*vue2d;
		frame2d				*vue2d_nonmodif;
		panelOpenGL3d		*vue3d;
		statusBarChargement	*m_statbarLoading;
		
		wxStaticText 		*seuil_text;
		wxSlider			*slide_seuilmin;
		wxSlider			*slide_seuilmax;		
		wxSlider			*slide_mouvement_hauteur;
		wxSlider			*slide_mouvement_temps;
		loadingVolume 		*choixChargement;
		
		wxTextCtrl			*miniscript;
	
	
	private:
		int					dimension;
		popupMenu			*popupMenuFonction;
		wxTextCtrl 			*tmp;
		
		wxAuiManager		auiManager;
		
		wxButton			*bouton_seuiller;
		wxButton			*bouton_binariser;
		
		wxMenu 				*menuFichier, *menuImport, *menuExport;
		wxMenu				*menu2d, *menu3d, *menu4d;
		wxMenu				*menuFenetre, *menuSurfacesImplicites, *menuParametre, *menuAbout;
		wxMenuBar			*menuBarre;	
		wxToolBar			*toolBar;
		miniFrame	  		*miniFrameSeuillage;
		miniFrame	  		*miniFrameHistogramme;
		miniFrame	  		*miniFrameScript;
		affHisto	  		*histo;
		
		wxSpinCtrl 			*spinSeuilMin;
		wxSpinCtrl 			*spinSeuilMax;
		
		DECLARE_EVENT_TABLE()
};


#endif
