#include "mainframe.h"


/* includes wxWidget pour les images */
#include <wx/artprov.h>
#include "bitmaps/open.xpm"
#include "bitmaps/save.xpm"
#include "bitmaps/quit.xpm"
#include "bitmaps/histogramme.xpm"
#include "bitmaps/seuil.xpm"
#include "bitmaps/gauss.xpm"
#include "bitmaps/erosion.xpm"
#include "bitmaps/dilatation.xpm"
#include "bitmaps/ouverture.xpm"
#include "bitmaps/fermeture.xpm"
#include "bitmaps/suppress.xpm"
#include "bitmaps/contour.xpm"
#include "bitmaps/fonctions.xpm"
#include "bitmaps/script.xpm"
#include "bitmaps/huitbits.xpm"
#include "bitmaps/ouvrir_script.xpm"
#include "bitmaps/executer_script.xpm"
#include "bitmaps/enregistrer_script.xpm"
#include "bitmaps/conversion3d.xpm"


/* liste de vnements lis */
BEGIN_EVENT_TABLE(Fenetre, wxFrame)
	/* Fichier */
	EVT_MENU		( ID_MENU_OUVRIR_SEQ, 		Fenetre::OnMenuOuvrir)
	EVT_MENU		( wxID_OPEN, 				Fenetre::OnMenuOuvrir)
	EVT_MENU		( ID_MENU_IMPORT_DV,		Fenetre::OnMenuOuvrir)
	EVT_MENU		( ID_MENU_IMPORT_3D,		Fenetre::OnMenuOuvrir)
	EVT_MENU		( ID_MENU_IMPORT_OBJ,		Fenetre::OnMenuOuvrir)
	EVT_MENU		( ID_MENU_EXPORT_DV,		Fenetre::OnMenuSave)
	EVT_MENU		( ID_MENU_EXPORT_3D,		Fenetre::OnMenuSave)
	EVT_MENU		( ID_MENU_EXPORT_OBJ,		Fenetre::OnMenuSave)
	EVT_MENU		( ID_MENU_EXPORT_NUAGE,		Fenetre::OnMenuExportNuage)
	EVT_MENU		( ID_MENU_LOADSCRIPT,		Fenetre::OnMenuScript)
	EVT_MENU		( ID_MENU_EXECSCRIPT,		Fenetre::OnMenuScript)
	EVT_MENU		( ID_MENU_SAVESCRIPT,		Fenetre::OnMenuScript)
	EVT_MENU		( ID_TOOL_CONVERSION3D,		Fenetre::OnLancerThread)
	EVT_MENU		( wxID_EXIT,  				Fenetre::OnMenuQuitter)
	EVT_MENU		( wxID_SAVE,	 		 	Fenetre::OnMenuSave)
	/* 2D */
	EVT_MENU		( ID_TOOL_SEUILLAGE_2D,  	Fenetre::OnOpenSeuillage)
	EVT_MENU		( ID_TOOL_GAUSSIEN_2D, 		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DILATATION_2D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_EROSION_2D,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_OUVERTURE_2D,  	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_FERMETURE_2D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_SUPPRESS_2D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONTOUR_2D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONVERSION3D_2D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DEFAULT_2D,		Fenetre::OnDefault)
	/* 3D */
	EVT_MENU		( ID_TOOL_SEUILLAGE_3D,  	Fenetre::OnOpenSeuillage)
	EVT_MENU		( ID_TOOL_GAUSSIEN_3D, 		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DILATATION_3D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_EROSION_3D,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_OUVERTURE_3D,  	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_FERMETURE_3D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_SUPPRESS_3D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONTOUR_3D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONVERSION3D_3D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DEFAULT_3D,		Fenetre::OnDefault)
	/* 4D */
	EVT_MENU		( ID_TOOL_SEUILLAGE_4D,  	Fenetre::OnOpenSeuillage)
	EVT_MENU		( ID_TOOL_GAUSSIEN_4D, 		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DILATATION_4D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_EROSION_4D,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_OUVERTURE_2D,  	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_FERMETURE_2D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_SUPPRESS_4D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONTOUR_4D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONVERSION3D_4D,	Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DEFAULT_4D,		Fenetre::OnDefault)
	/* parametre */
	EVT_MENU		( ID_MENU_RES8,		  		Fenetre::OnChangementResolution)
	EVT_MENU		( ID_MENU_RES16,		  	Fenetre::OnChangementResolution)
	EVT_MENU		( ID_MENU_RES32,		  	Fenetre::OnChangementResolution)
	EVT_MENU		( ID_MENU_RES64,		  	Fenetre::OnChangementResolution)
	EVT_MENU		( ID_MENU_RES128,		  	Fenetre::OnChangementResolution)
	/* commun ou toolbar */
	EVT_MENU		( ID_TOOL_CONVERTIR,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_SEUILLAGE,  		Fenetre::OnOpenSeuillage)
	EVT_MENU		( ID_TOOL_GAUSSIEN, 		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_DILATATION,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_EROSION,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_OUVERTURE,  		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_FERMETURE,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_SUPPRESS,			Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_CONTOUR,			Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_HISTOGRAMME, 		Fenetre::OnOpenHistogramme)
	EVT_MENU		( ID_TOOL_SCRIPT,	 		Fenetre::OnOpenScript)
	EVT_MENU		( ID_TOOL_CONVERSION3D,		Fenetre::OnLancerThread)
	EVT_MENU		( ID_TOOL_FUNCTION, 		Fenetre::OnFonction)
	/* about */
	EVT_MENU		( ID_MENU_ABOUT, 			Fenetre::OnAbout)	
	/* fentre */
	EVT_SIZE		(							Fenetre::OnSize)
    EVT_CLOSE		(							Fenetre::OnClose)
END_EVENT_TABLE()


/* constucteur de la fentre principale */
Fenetre::Fenetre(const wxString& title, const wxPoint& pos, const wxSize& size, long style) : wxFrame(NULL, -1, title, pos, size, style)
{
	/* initialisation des variables */
	dimension = DIM_3D;
	moment = 0;
	popupMenuFonction = NULL;
	miniFrameSeuillage = NULL;
	vue3d = NULL;
	
	/* attache du gestionnaire d'interface */	
	auiManager.SetManagedWindow(this);
	/* couleur de fond */
	SetBackgroundColour(wxSystemSettings::GetColour(wxSYS_COLOUR_BTNFACE));
	
	
	/*------------------------[ cration de la statusbar ]------------------------*/
	
	m_statbarLoading = new statusBarChargement(this);
	SetStatusBar(m_statbarLoading);
	GetStatusBar()->Show();
	PositionStatusBar();
	
	
	/*------------------------[ cration des menus ]------------------------*/
	
	/* menu IMPORT */
	menuImport = new wxMenu;
	menuImport->Append(ID_MENU_IMPORT_DV,            _T("DV"),  _T("Permet de charger un fichier au format DV"));
	menuImport->Append(ID_MENU_IMPORT_3D,            _T("3D"),  _T("Permet de charger un fichier au format 3D"));
	menuImport->Append(ID_MENU_IMPORT_OBJ,           _T("OBJ"), _T("Permet de charger un fichier au format OBJ"));
	
	/* menu EXPORT */
	menuExport = new wxMenu;
	menuExport->Append(ID_MENU_EXPORT_DV,            _T("DV"),  _T("Permet d'exporter au format DV"));
	menuExport->Append(ID_MENU_EXPORT_3D,            _T("3D"),  _T("Permet d'exporter au format 3D"));
	menuExport->Append(ID_MENU_EXPORT_OBJ,           _T("OBJ"), _T("Permet d'exporter au format OBJ"));
	
	/* menu FICHIER */
	menuFichier = new wxMenu;
	menuFichier->Append(wxID_OPEN,                   _T("Ouvrir un &volume numerique.\tCtrl-O"), _T("Ouvre un volume numerique (un seul fichier RAW)"));
	menuFichier->Append(ID_MENU_OUVRIR_SEQ,          _T("Ouvrir une &sequence de volumes numeriques."), _T("Ouvre une sequence (plusieurs fichiers RAW)"));
	menuFichier->Append(wxID_ANY,                    _T("&Importer"), menuImport);
	menuFichier->Append(wxID_ANY,                    _T("&Exporter"), menuExport);
	menuFichier->Append(ID_MENU_EXPORT_NUAGE,        _T("Exporter &nuage de point."), _T("Permet l'export de points (mode binaire uniquement)"));
	menuFichier->Append(ID_MENU_LOADSCRIPT,          _T("&Charger un script."), _T("Chargement d'un script"));
	menuFichier->Append(ID_MENU_EXECSCRIPT,          _T("Executer le &script."), _T("Lancement du script courant"));
	menuFichier->Append(ID_MENU_SAVESCRIPT,          _T("Enregistrer le script."), _T("Sauvegarde du script courant"));
	menuFichier->Append(wxID_SAVE,                   _T("Sauvegarder."), _T("Sauvegarde la sequence courante"));
	menuFichier->AppendSeparator();
	menuFichier->Append(wxID_EXIT,                   _T("&Quitter\tCtrl-W"), _T("Quitte le programme"));
	
	/* menu 2D */
	menu2d = new wxMenu(80);
	menu2d->Append(ID_TOOL_SEUILLAGE,                _T("Seuiller"), _T(""));
	menu2d->Append(ID_APPLIQUER_INVERSION_2D,        _T("Appliquer fonction Inversion"), _T(""));
	menu2d->Append(ID_APPLIQUER_CARREE_2D,           _T("Appliquer fonction Carree"), _T(""));
	menu2d->Append(ID_APPLIQUER_EXP_2D,              _T("Appliquer fonction Exponentielle"), _T(""));
	menu2d->Append(ID_APPLIQUER_LOG_2D,              _T("Appliquer fonction Logarithmique"), _T(""));
	menu2d->Append(ID_TOOL_GAUSSIEN_2D,              _T("Appliquer filtre gaussien"), _T(""));
	menu2d->Append(ID_TOOL_EROSION_2D,               _T("Eroder"), _T(""));
	menu2d->Append(ID_TOOL_DILATATION_2D,            _T("Dilater"), _T(""));
	menu2d->Append(ID_TOOL_OUVERTURE_2D,             _T("Ouvrir"), _T(""));
	menu2d->Append(ID_TOOL_FERMETURE_2D,             _T("Fermer"), _T(""));
	menu2d->AppendSeparator();
	menu2d->Append(ID_TOOL_SUPPRESS_2D,              _T("Supprimer parasites"), _T(""));
	menu2d->Append(ID_TOOL_CONTOUR_2D,               _T("Extraire contour"), _T(""));
	menu2d->Append(ID_TOOL_CONVERSION3D_2D,          _T("Convertir en 3D"), _T(""));
	menu2d->AppendSeparator();
	menu2d->AppendCheckItem(ID_TOOL_DEFAULT_2D,      _T("Defaut"), _T(""));
	
	/* menu 3D */
	menu3d = new wxMenu;
	menu3d->Append(ID_TOOL_SEUILLAGE,                _T("Seuiller"), _T(""));
	menu3d->Append(ID_APPLIQUER_INVERSION_3D,        _T("Appliquer fonction Inversion"), _T(""));
	menu3d->Append(ID_APPLIQUER_CARREE_3D,           _T("Appliquer fonction Carree"), _T(""));
	menu3d->Append(ID_APPLIQUER_EXP_3D,              _T("Appliquer fonction Exponentielle"), _T(""));
	menu3d->Append(ID_APPLIQUER_LOG_3D,              _T("Appliquer fonction Logarithmique"), _T(""));
	menu3d->Append(ID_TOOL_GAUSSIEN_3D,              _T("Appliquer filtre gaussien"), _T(""));
	menu3d->Append(ID_TOOL_EROSION_3D,               _T("Eroder"), _T(""));
	menu3d->Append(ID_TOOL_DILATATION_3D,            _T("Dilater"), _T(""));
	menu3d->Append(ID_TOOL_OUVERTURE_3D,             _T("Ouvrir"), _T(""));
	menu3d->Append(ID_TOOL_FERMETURE_3D,             _T("Fermer"), _T(""));
	menu3d->AppendSeparator();
	menu3d->Append(ID_TOOL_SUPPRESS_3D,              _T("Supprimer parasites"), _T(""));
	menu3d->Append(ID_TOOL_CONTOUR_3D,               _T("Extraire contour"), _T(""));
	menu3d->Append(ID_TOOL_CONVERSION3D_3D,          _T("Convertir en 3D"), _T(""));
	menu3d->AppendSeparator();
	menu3d->AppendCheckItem(ID_TOOL_DEFAULT_3D,      _T("Defaut"), _T(""));
	
	/* menu 4D */
	menu4d = new wxMenu;
	menu4d->Append(ID_TOOL_SEUILLAGE,                _T("Seuiller"), _T(""));
	menu4d->Append(ID_APPLIQUER_INVERSION_4D,        _T("Appliquer fonction Inversion"), _T(""));
	menu4d->Append(ID_APPLIQUER_CARREE_4D,           _T("Appliquer fonction Carree"), _T(""));
	menu4d->Append(ID_APPLIQUER_EXP_4D,              _T("Appliquer fonction Exponentielle"), _T(""));
	menu4d->Append(ID_APPLIQUER_LOG_4D,              _T("Appliquer fonction Logarithmique"), _T(""));
	menu4d->Append(ID_TOOL_GAUSSIEN_4D,              _T("Appliquer filtre gaussien"), _T(""));
	menu4d->Append(ID_TOOL_EROSION_4D,               _T("Eroder"), _T(""));
	menu4d->Append(ID_TOOL_DILATATION_4D,            _T("Dilater"), _T(""));
	menu4d->Append(ID_TOOL_OUVERTURE_4D,             _T("Ouvrir"), _T(""));
	menu4d->Append(ID_TOOL_FERMETURE_4D,             _T("Fermer"), _T(""));
	menu4d->AppendSeparator();
	menu4d->Append(ID_TOOL_SUPPRESS_4D,              _T("Supprimer parasites"), _T(""));
	menu4d->Append(ID_TOOL_CONTOUR_4D,               _T("Extraire contour"), _T(""));
	menu4d->Append(ID_TOOL_CONVERSION3D_4D,          _T("Convertir en 3D"), _T(""));
	menu4d->AppendSeparator();
	menu4d->AppendCheckItem(ID_TOOL_DEFAULT_4D,      _T("Defaut"), _T(""));
	
	/* menu Fenetre */
	menuFenetre = new wxMenu;
	menuFenetre->Append(ID_TOOL_SEUILLAGE,           _T("Seuil"), _T(""));
	menuFenetre->Append(ID_TOOL_HISTOGRAMME,         _T("Histogramme"), _T(""));
	menuFenetre->Append(ID_TOOL_SCRIPT,              _T("Script"), _T(""));
	
	/* menu Surfaces implicites */
	menuSurfacesImplicites = new wxMenu;
	menuSurfacesImplicites->AppendCheckItem(ID_MENU_RES8,   _T("Resolution 8"),  _T(""));
	menuSurfacesImplicites->AppendCheckItem(ID_MENU_RES16,  _T("Resolution 16"),  _T(""));
	menuSurfacesImplicites->AppendCheckItem(ID_MENU_RES32,  _T("Resolution 32"),  _T(""));
	menuSurfacesImplicites->AppendCheckItem(ID_MENU_RES64,  _T("Resolution 64"),  _T(""));
	menuSurfacesImplicites->AppendCheckItem(ID_MENU_RES128, _T("Resolution 128"), _T(""));
	menuSurfacesImplicites->Check(ID_MENU_RES16, true);
	
	/* menu Parametre */
	menuParametre = new wxMenu;
	menuParametre->Append(wxID_ANY,                   _T("&Surfaces implicites"), menuSurfacesImplicites);
	
	/* menu about */
	menuAbout = new wxMenu;
	menuAbout->Append(ID_MENU_ABOUT,                 _T("A propos."), _T("Affiche les informations du programme"));
	
	/* menu principal */
	menuBarre = new wxMenuBar();
	menuBarre->Append(menuFichier,_T("&Fichier"));
	menuBarre->Append(menu2d,_T("&2D"));
	menuBarre->Append(menu3d,_T("&3D"));
	menuBarre->Append(menu4d,_T("&4D"));
	menuBarre->Append(menuFenetre,_T("&Fenetre"));
	menuBarre->Append(menuParametre, _T("&Parametre"));
	menuBarre->Append(menuAbout,_T("&?"));
	SetMenuBar(menuBarre);
	
	
	/*------------------------[ cration des toolbars ]------------------------*/
	
	/* toolbar des raccourcis menu */
    toolBar = CreateToolBar(wxTB_FLAT | wxTB_TEXT | wxTB_TOP, -1);
	
    toolBar->AddTool(wxID_OPEN,                      _T("Ouvrir"), wxBITMAP(open), wxNullBitmap, wxITEM_NORMAL, _T("Ouvrir une sequence"), _T("Ouvre une sequence (plusieurs fichiers RAW)"));
    toolBar->AddTool(wxID_SAVE,                      _T("Sauvegarder"), wxBITMAP(save), wxNullBitmap, wxITEM_NORMAL, _T("Sauvegarde la sequence en cours"), _T("Sauvegarde la sequence (au format souhaite)"));
	toolBar->AddSeparator();
	toolBar->AddTool(ID_TOOL_CONVERSION3D,           _T("Conversion 3D"), wxBITMAP(conversion3d), _T("Permet de convertir un volume d'images en 3d"));	
	toolBar->AddTool(wxID_EXIT,                      _T("Quitter"), wxBITMAP(quit), _T("Quitte le programme"), wxITEM_CHECK);
	toolBar->Realize();
	
	/* toolbar des traitements */	
    barre_menu = new wxToolBar(this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxTB_FLAT | wxTB_NODIVIDER | wxTB_VERTICAL);
    barre_menu->SetToolBitmapSize(wxSize(48,48));
	
    barre_menu->AddCheckTool(ID_TOOL_HISTOGRAMME,    _T("Histogramme"), wxBITMAP(histogramme));
    barre_menu->AddCheckTool(ID_TOOL_SCRIPT,	     _T("Script"), wxBITMAP(script));
    barre_menu->AddTool(ID_TOOL_CONVERTIR,           _T("Convertir"), wxBITMAP(huitbits));
	barre_menu->AddSeparator();
	
    barre_menu->AddCheckTool(ID_TOOL_SEUILLAGE,      _T("Seuiller"), wxBITMAP(seuil));
    barre_menu->AddTool(ID_TOOL_FUNCTION,            _T("Fonctions"), wxBITMAP(fonctions));
    barre_menu->AddTool(ID_TOOL_GAUSSIEN,            _T("Filtre"), wxBITMAP(gauss));
    barre_menu->AddTool(ID_TOOL_EROSION,             _T("Erosion"), wxBITMAP(erosion));
    barre_menu->AddTool(ID_TOOL_DILATATION,          _T("Dilatation"), wxBITMAP(dilatation));
    barre_menu->AddTool(ID_TOOL_OUVERTURE,           _T("Ouverture"), wxBITMAP(ouverture));
    barre_menu->AddTool(ID_TOOL_FERMETURE,           _T("Fermeture"), wxBITMAP(fermeture));
    barre_menu->AddTool(ID_TOOL_SUPPRESS,            _T("Suppression"), wxBITMAP(suppress));
    barre_menu->AddTool(ID_TOOL_CONTOUR,             _T("Contour"), wxBITMAP(contour));
    barre_menu->Realize();
	barre_menu->Enable(false);
	
	
	/*------------------------[ cration des panes ]------------------------*/
	
	/* vue 2d */
	vue2d = new frame2d(this);
	auiManager.AddPane(vue2d,
		wxAuiPaneInfo().Center().Layer(2).Name(wxT("pane_opengl2d")).Caption(wxT("Vue 2d")).
		CloseButton(false).MaximizeButton(false).Floatable(false));
	
	/* ajout de la toolbar des traitements */	
    auiManager.AddPane(barre_menu, wxAuiPaneInfo().Name(wxT("barre_menu")).GripperTop().Caption(wxT("")).
		ToolbarPane().LeftDockable(true).RightDockable(true).Right().Layer(1).Show());
	
	
	/*------------------------[ cration des miniframes ]------------------------*/
	
	/* miniframe : Seuillage */
	creerSeuillage(false);
	
	/* miniframe : Histogramme */
	creerHistogramme(false);
	
	/* miniframe : Script */
	creerScript(false);	
		
	
	/*------------------------[ dsactivation des menus non-utilisables ]------------------------*/
	
	desactiverMenus(DIM_4D);
	
	
	elementStruct::creerFenetre(this);
	miseAJour(MAJ_MENUCHECK);
    auiManager.Update();
}


/*------------------------------------------------------------------------------[             vnements fentre ]---------------*/


/* fentre redimenssionne */
void Fenetre::OnSize (wxSizeEvent& WXUNUSED(event))
{
    auiManager.Update();
}


/* fermeture du programme */
void Fenetre::OnClose (wxCloseEvent& WXUNUSED(event))
{
	/* supression des fichiers temporaires */
	remove(".tmp"); /* script */
	remove(".obj"); /* obj    */
	
	/* destruction des miniframes */
	if (miniFrameSeuillage)
		miniFrameSeuillage->Destroy();
	
	if (miniFrameHistogramme)
		miniFrameHistogramme->Destroy();
	
	if (miniFrameScript)
		miniFrameScript->Destroy();
	
	elementStruct::destroy();
	
	/* destruction de la squence */
	coeur.~sequence();
	auiManager.UnInit();
	exit(0);
}


/*------------------------------------------------------------------------------[         vnements sur le menu ]---------------*/


/* demande d'ouverture d'une squence (pls volumes) */
void Fenetre::OnMenuOuvrir (wxCommandEvent&event)
{	
    wxString path;
    wxString filename;
    wxArrayInt fileTypes;
	wxString ligne;
	wxString filter;

	if (event.GetId() == ID_MENU_IMPORT_DV)
		filter = wxT("Fichiers DV (*.dv)|*.dv;*.Dv;*.DV");
	else if (event.GetId() == ID_MENU_IMPORT_3D)
		filter = wxT("Fichiers 3D (*.3d)|*.3d;*.3D");
	else if (event.GetId() == ID_MENU_IMPORT_OBJ)
		filter = wxT("Fichiers OBJ (*.obj)|*.obj;*.Obj;*.oBj;*.obJ;*.OBj;*.oBJ;*.OBJ");
	else
		filter = wxT("Fichiers de configuration (*.txt)|*.txt|Tous les fichiers (*.*)|*.*");

    wxFileDialog dialog(this,
        _("Choix du fichier de configuration"),
        path,
        filename,
        filter,
        wxFD_OPEN);

    if (dialog.ShowModal() == wxID_OK)
    {
        path = dialog.GetDirectory() + _T("/");
		filename = dialog.GetFilename();
		
        if (!path.empty())
        {
			if (event.GetId() == ID_MENU_IMPORT_OBJ)
				m_statbarLoading->setAction(ID_OBJ);
			else
				m_statbarLoading->setAction(ID_OPEN);
			
			MyThread *thread = new MyThread(this, event.GetId());
			thread->setPath(string((path).mb_str(wxConvLibc)));
			thread->setFichier(string((filename).mb_str(wxConvLibc)));
			
			if (event.GetId()!=ID_MENU_IMPORT_DV && event.GetId()!=ID_MENU_IMPORT_3D && event.GetId()!=ID_MENU_IMPORT_OBJ)
			{
				thread->setAction(ID_OPEN);
				choixChargement = new loadingVolume(this, this);
				
				ligne = wxString::Format(_T("Charger config %s %s\n"), path.c_str(), filename.c_str());
				miniscript->AppendText(ligne);
				script::traiterLigne(string((ligne).mb_str(wxConvLibc)), &coeur);
				
				choixChargement->setMax(coeur.getNomImage(), coeur.getDuree());
				choixChargement->ShowModal();
				
				if (choixChargement->indice == -1)
					return;
				
				thread->setIndice(choixChargement->indice);				
				delete choixChargement;
				
				thread->ouvertureSequence(event.GetId()==ID_MENU_OUVRIR_SEQ);
				m_statbarLoading->setDimension((event.GetId()==ID_MENU_OUVRIR_SEQ)?DIM_4D:DIM_3D);
			}
			
			if ( thread->Create() != wxTHREAD_NO_ERROR )
				wxLogError(wxT("Creation du thread impossible."));
			
			if ( thread->Run() != wxTHREAD_NO_ERROR )
				wxLogError(wxT("Impossible de demarrer le thread."));
        }
    }
	Refresh(true);
}


/* demande de sauvegarde */
void Fenetre::OnMenuSave (wxCommandEvent &event)
{
    wxString path;
    wxString filename;
    wxArrayInt fileTypes;
	wxString ligne;
	wxString filter;

	if (event.GetId() == ID_MENU_EXPORT_DV)
		filter = wxT("Fichiers DV (*.dv)|*.dv;*.Dv;*.DV");
	else if (event.GetId() == ID_MENU_EXPORT_3D)
		filter = wxT("Fichiers 3D (*.3d)|*.3d;*.3D");
	else if (event.GetId() == ID_MENU_EXPORT_OBJ)
		filter = wxT("Fichiers OBJ (*.obj)|*.obj;*.Obj;*.oBj;*.obJ;*.OBj;*.oBJ;*.OBJ");
	else
		filter = wxT("Nom des images (*.*)|*.*");

    wxFileDialog dialog(this,
        _("Choix du fichier de configuration"),
        path,
        filename,
        filter,
        wxSAVE);

    if (dialog.ShowModal() == wxID_OK)
    {
        path = dialog.GetDirectory() + _T("/");
		filename = dialog.GetFilename();
		
        if (!path.empty())
        {
			if (event.GetId() == ID_MENU_EXPORT_OBJ)
				m_statbarLoading->setAction(ID_OBJ);
			else
				m_statbarLoading->setAction(ID_SAVE);
			
			
			MyThread *thread = new MyThread(this, event.GetId());
			thread->setPath(string((path).mb_str(wxConvLibc)));
			thread->setFichier(string((filename).mb_str(wxConvLibc)));
			
			if (event.GetId()!=ID_MENU_EXPORT_DV && event.GetId()!=ID_MENU_EXPORT_3D && event.GetId()!=ID_MENU_EXPORT_OBJ)
			{
				thread->setAction(ID_SAVE);
				MyThread *thread = new MyThread(this, ID_SAVE);
				
				thread->setPath(string((path).mb_str(wxConvLibc)));
				thread->setFichier(string((filename).mb_str(wxConvLibc)));
				
				ligne = wxString::Format(_T("Sauvegarder config %s SIZE.txt %s\n"), path.c_str(), filename.c_str());
				miniscript->AppendText(ligne);
				script::traiterLigne(string((ligne).mb_str(wxConvLibc)), &coeur);
			}
			
			if ( thread->Create() != wxTHREAD_NO_ERROR )
				wxLogError(wxT("Creation du thread impossible."));
			
			if ( thread->Run() != wxTHREAD_NO_ERROR )
				wxLogError(wxT("Impossible de demarrer le thread."));
        }
    }
	Refresh(true);
}


void Fenetre::OnMenuExportNuage (wxCommandEvent &WXUNUSED(event))
{
	wxString path;
    wxString filename;
	wxString filter = wxT("*.*|*.*");
    wxFileDialog dialog(this, _T("Fichier export"), path, filename, filter, wxSAVE);

    if (dialog.ShowModal() == wxID_OK)
    {
		wxTextEntryDialog input(this, _T("Structure du fichier de sortie ({X}, {Y}, {Z} seront remplaces par les coordonnees des points)"), _T("Structure"), _T("{X} {Y} {Z}"));
		if (input.ShowModal() == wxID_OK)
		{
			string tmp1, tmp2;
			tmp1 = string((dialog.GetPath()).mb_str(wxConvLibc));
			tmp2 = string((input.GetValue()).mb_str(wxConvLibc));
			coeur.sauvegarderPoints(moment, tmp1, tmp2);
		}
	}
}


void Fenetre::OnMenuScript (wxCommandEvent &event)
{
	if (event.GetId() == ID_MENU_EXECSCRIPT)
	{
		/* on sauvegarde le script courant puis on le traite */
		script sc(".tmp", &coeur);
		sc.ecrire(miniscript);
		m_statbarLoading->setAction(ID_SCRIPT);
		m_statbarLoading->setDimension(sc.getNombreOperations());
		
		MyThread *thread = new MyThread(this, ID_MENU_EXECSCRIPT);
		
		if ( thread->Create() != wxTHREAD_NO_ERROR )
			wxLogError(wxT("Creation du thread impossible."));
		
		if ( thread->Run() != wxTHREAD_NO_ERROR )
			wxLogError(wxT("Impossible de demarrer le thread."));
	}
	else
	{
		wxString path;
		wxString filename;
		wxArrayInt fileTypes;
		wxString ligne;
		wxString filter = wxT("Script (*.txt)|*.txt");
		long style;
		
		if (event.GetId() == ID_MENU_LOADSCRIPT)
			style = wxOPEN;
		else if (event.GetId() == ID_MENU_SAVESCRIPT)
			style = wxSAVE;
		
		wxFileDialog dialog(this,
			_("Choix du script"),
			path,
			filename,
			filter,
			style);

		if (dialog.ShowModal() == wxID_OK)
		{
			path = dialog.GetDirectory() + _T("/");
			filename = dialog.GetFilename();
			
			if (!path.empty())
			{
				ligne = wxString::Format(_T("%s%s"), path.c_str(), filename.c_str());
				script sc(string((ligne).mb_str(wxConvLibc)), &coeur);
				
				if (event.GetId() == ID_MENU_LOADSCRIPT)
					sc.lire(miniscript);
				else if (event.GetId() == ID_MENU_SAVESCRIPT)
					sc.ecrire(miniscript);
			}
		}
	}
	
	Refresh(true);
}


/* affiche le popup menu (toolbar avance, demande d'application d'une fonction) */
void Fenetre::OnFonction (wxCommandEvent &event)
{
    delete popupMenuFonction;
    popupMenuFonction = new popupMenu(this);
	popupMenuFonction->ajoutLien(_T("inversion"), ID_APPLIQUER_INVERSION);
	popupMenuFonction->ajoutLien(_T("carree"), ID_APPLIQUER_CARREE);
	popupMenuFonction->ajoutLien(_T("exponentielle"), ID_APPLIQUER_EXP);
	popupMenuFonction->ajoutLien(_T("logarithmique"), ID_APPLIQUER_LOG);
	popupMenuFonction->finAjout();
    wxWindow *btn = (wxWindow*) event.GetEventObject();
    wxPoint pos = btn->ClientToScreen(wxPoint(0,0));
    wxSize sz = wxSize(-popupMenuFonction->GetSize().x+5,80);
    popupMenuFonction->Position (pos, sz);
    popupMenuFonction->Popup();
}


/* demande de fermeture du programme */
void Fenetre::OnMenuQuitter (wxCommandEvent& WXUNUSED(event))
{
	Close(true);
}


/* affiche le about */
void Fenetre::OnAbout (wxCommandEvent &WXUNUSED(event))
{
	wxAboutDialogInfo info;
    info.SetName(_("seg3D ::: code of the death"));
    info.SetVersion(_("1.0.0 Beta"));
    info.SetDescription(_("Programme de segmentation."));
    info.SetCopyright(_T("(C) 2007 Benjamin DUPLEX <benjamin.duplex@gmail.com>"));

    wxAboutBox(info);	
}


/* change la rsolution du calcul de la surface implite */
void Fenetre::OnChangementResolution (wxCommandEvent &event)
{
	wxString ligne;
	menuSurfacesImplicites->Check(ID_MENU_RES8,   event.GetId() == ID_MENU_RES8  );
	menuSurfacesImplicites->Check(ID_MENU_RES16,  event.GetId() == ID_MENU_RES16 );
	menuSurfacesImplicites->Check(ID_MENU_RES32,  event.GetId() == ID_MENU_RES32 );
	menuSurfacesImplicites->Check(ID_MENU_RES64,  event.GetId() == ID_MENU_RES64 );
	menuSurfacesImplicites->Check(ID_MENU_RES128, event.GetId() == ID_MENU_RES128);
	
	if (event.GetId() == ID_MENU_RES8)
		ligne = wxString::Format(_T("Specifier resolution %d\n"), RESOLUTION_8);
	else if (event.GetId() == ID_MENU_RES16)
		ligne = wxString::Format(_T("Specifier resolution %d\n"), RESOLUTION_16);
	else if (event.GetId() == ID_MENU_RES32)
		ligne = wxString::Format(_T("Specifier resolution %d\n"), RESOLUTION_32);
	else if (event.GetId() == ID_MENU_RES64)
		ligne = wxString::Format(_T("Specifier resolution %d\n"), RESOLUTION_64);
	else if (event.GetId() == ID_MENU_RES128)
		ligne = wxString::Format(_T("Specifier resolution %d\n"), RESOLUTION_128);

	miniscript->AppendText(ligne);
	script::traiterLigne(string((ligne).mb_str(wxConvLibc)), &coeur);
}


/*------------------------------------------------------------------------------[                       vnements miniframe ]---------------*/


/* on ouvre/ferme la miniframe permettant de faire un seuillage de l'image */
void Fenetre::OnOpenSeuillage (wxCommandEvent &WXUNUSED(event))
{
	miniFrameSeuillage->Show(!miniFrameSeuillage->IsShown());
	
    auiManager.Update();
}


/* dplacement du slide pour le seuillage min */
void Fenetre::OnSlideMinMove (wxScrollEvent &event)
{
	if (event.GetPosition() > slide_seuilmax->GetValue())
		slide_seuilmax->SetValue(event.GetPosition());
	
	slide_seuilmin->SetValue(event.GetPosition());
	
	miseAJour(MAJ_SEUIL);
	miseAJour(MAJ_HISTO);
	MaJimage(moment,vue2d->getHauteurCoupe());
	Refresh(true);
}


/* dplacement du slide pour le seuillage max */
void Fenetre::OnSlideMaxMove (wxScrollEvent &event)
{
	if (event.GetPosition() < slide_seuilmin->GetValue())
		slide_seuilmin->SetValue(event.GetPosition());
	
	slide_seuilmax->SetValue(event.GetPosition());	
	
	miseAJour(MAJ_SEUIL);
	miseAJour(MAJ_HISTO);
	MaJimage(moment,vue2d->getHauteurCoupe());
	Refresh(true);
}


/* dplacement du splin pour le seuillage min */
void Fenetre::OnSpinSeuilMin (wxSpinEvent &event)
{
	slide_seuilmin->SetValue(event.GetPosition());
	miseAJour(MAJ_SEUIL);
	miseAJour(MAJ_HISTO);
	MaJimage(moment, vue2d->getHauteurCoupe());
	Refresh(true);
}


/* dplacement du spin pour le seuillage max */
void Fenetre::OnSpinSeuilMax (wxSpinEvent &event)
{
	slide_seuilmax->SetValue(event.GetPosition());
	miseAJour(MAJ_SEUIL);
	miseAJour(MAJ_HISTO);
	MaJimage(moment, vue2d->getHauteurCoupe());
	Refresh(true);
}


/* demande de seuillage */
void Fenetre::OnSeuiller (wxCommandEvent &WXUNUSED(event))
{
	miniscript->AppendText(wxString::Format(_T("Seuiller (%i, %i)\n"),
		slide_seuilmin->GetValue(), slide_seuilmax->GetValue()));
	
	coeur.seuillerImageTemps(moment, slide_seuilmin->GetValue(), slide_seuilmax->GetValue());
	miseAJour(INIT_SEUIL);
	miseAJour(MAJ_HISTO);
	Refresh(true);
}


/* demande de binarisation => seuillage obligatoire */
void Fenetre::OnBinarisation (wxCommandEvent &WXUNUSED(event))
{
	miseAJour(INIT_SEUIL);
	miseAJour(MAJ_HISTO);
	Refresh(true);
}


/* on ouvre/ferme la miniframe permettant de faire un seuillage de l'image */
void Fenetre::OnOpenHistogramme (wxCommandEvent &WXUNUSED(event))
{
	miniFrameHistogramme->Show(!miniFrameHistogramme->IsShown());
    auiManager.Update();
}


/* on ouvre/ferme la miniframe permettant de voir le script en cours */
void Fenetre::OnOpenScript (wxCommandEvent &WXUNUSED(event))
{
	miniFrameScript->Show(!miniFrameScript->IsShown());
    auiManager.Update();
}


/* on applique une dilatation sur l'image */
void Fenetre::OnLancerThread (wxCommandEvent &event)
{
	int operation, dimAction;
	
	operation = (event.GetId()<200)?((dimension-1)*100+event.GetId()):event.GetId();
	dimAction = operation/100;
	operation =  (operation+100) - dimAction*100;
	
	
	/* la conversion se fait forcment sur toutes les images (-> 4D) */
	if (operation == ID_TOOL_CONVERTIR)
		dimAction = DIM_4D;
	
	/* la conversion OBJ via les surfaces implicites est limite  la 3D */
	if (operation == ID_TOOL_CONVERSION3D)
		dimAction = DIM_3D;
	
	/* configuration de l'lment structurant */
	bool morpho;
	morpho  = operation==ID_TOOL_DILATATION;
	morpho |= operation==ID_TOOL_EROSION;
	morpho |= operation==ID_TOOL_OUVERTURE;
	morpho |= operation==ID_TOOL_FERMETURE;
	if (morpho)
	{
		elementStruct *tmp = elementStruct::getInstance();
		tmp->ShowModal();
	}
	
	/* la suppression des parasites n'est possible qu'en 3D ou 4D */
	bool force3d;
	force3d  = operation==ID_TOOL_SUPPRESS;
	force3d |= operation==ID_TOOL_CONVERTIR;
	if (force3d && dimAction==DIM_2D)
		dimAction = DIM_3D;
	
	if (operation==ID_TOOL_OUVERTURE || operation==ID_TOOL_FERMETURE)
		m_statbarLoading->setAction(ID_TRAITEMENT_2);
	else if (operation==ID_TOOL_CONVERSION3D || operation==ID_MENU_IMPORT_OBJ || operation==ID_MENU_EXPORT_OBJ)
		m_statbarLoading->setAction(ID_OBJ);
	else
		m_statbarLoading->setAction(ID_TRAITEMENT);
	
	m_statbarLoading->setDimension(dimAction);
	
	MyThread *thread = new MyThread(this, operation);
	thread->setDimension(dimAction);
	
	if ( thread->Create() != wxTHREAD_NO_ERROR )
		wxLogError(wxT("Creation du thread impossible."));
	
	if ( thread->Run() != wxTHREAD_NO_ERROR )
		wxLogError(wxT("Impossible de demarrer le thread."));
	
    auiManager.Update();
}


/* on applique une dilatation sur l'image */
void Fenetre::OnDefault (wxCommandEvent &event)
{
	if (event.GetId() == ID_TOOL_DEFAULT_2D)
		dimension = DIM_2D;
	else if (event.GetId() == ID_TOOL_DEFAULT_3D)
		dimension = DIM_3D;
	else if (event.GetId() == ID_TOOL_DEFAULT_4D)
		dimension = DIM_4D;

	miseAJour(MAJ_MENUCHECK);
    auiManager.Update();
}


/*------------------------------------------------------------------------------[                    autres fonctions ]---------------*/


void Fenetre::ajouterScript (wxString s)
{
	miniscript->AppendText(s);
}


/* mise  jour des image (affichage 2d) et des textures (affichage 3d) */
void Fenetre::MaJimage (int temps, int hauteurCoupe)
{
	coeur.seuillerImageTemporairement(slide_seuilmin->GetValue(), slide_seuilmax->GetValue());	
	hauteurCoupe = temps;
}


/* fonction regrouppant les mises  jour  faire */
void Fenetre::miseAJour (int choix)
{
	wxString str = _T("");
	
	if (choix == MAJ_MENUCHECK)
	{
		menu2d->Check(ID_TOOL_DEFAULT_2D, false);
		menu3d->Check(ID_TOOL_DEFAULT_3D, false);
		menu4d->Check(ID_TOOL_DEFAULT_4D, false);
		
		if (dimension == DIM_2D)
			menu2d->Check(ID_TOOL_DEFAULT_2D, true);
		else if (dimension == DIM_3D)
			menu3d->Check(ID_TOOL_DEFAULT_3D, true);
		else if (dimension == DIM_4D)
			menu4d->Check(ID_TOOL_DEFAULT_4D, true);
	}
	
	
	if (coeur.isValide())
	{
		switch (choix)
		{
			/* initialisation des seuils */
			case INIT_SEUIL:
				if (!coeur.isEmpty())
				{
					int valMax;
					valMax = coeur.getValeurMaximale(moment, vue2d->getHauteurCoupe());
					
					if (valMax > 0)
					{
						slide_seuilmin->SetRange(0, valMax);
						/*slide_seuilmin->SetValue(0);*/
						spinSeuilMin->SetRange(0, valMax);
						
						slide_seuilmax->SetRange(0, valMax);
						if (valMax < slide_seuilmax->GetValue())
							slide_seuilmax->SetValue(valMax);
						spinSeuilMax->SetRange(0, valMax);
					}
				}
				
			/* mise  jour des seuils */
			case MAJ_SEUIL:
				if (!coeur.isEmpty())
				{/*
					coeur.seuillerImageTemps(moment, -1, -1);
					*/
					str << _T("On ne garde que les pixels entre ");
					str << slide_seuilmin->GetValue();
					str << _T(" et ");
					str << slide_seuilmax->GetValue();
					seuil_text->SetLabel(str);
					
					spinSeuilMin->SetValue(slide_seuilmin->GetValue());
					spinSeuilMax->SetValue(slide_seuilmax->GetValue());
					miniFrameSeuillage->Refresh(true);
				}
				break;
			
			/* initialisation de l'histogramme */
			case INIT_HISTO:
				if (!coeur.isEmpty())
					histo->setVolume(coeur.getVolume(moment), vue2d->getHauteurCoupe());
				break;
			
			/* mise  jour de l'histogramme */
			case MAJ_HISTO:
				if (!coeur.isEmpty())
					histo->setVolume(coeur.getVolume(moment), vue2d->getHauteurCoupe());
				break;
			
			/* initialisation de la hauteur du slider de la vue 2d */
			case INIT_HAUTEUR:
				if (coeur.getNombreImage() > 0)
				{
					vue2d->slide_coupe->SetRange(0, coeur.getNombreImage()-1);
					vue2d->slide_coupe->SetValue(0);
				}
				break;
		}
	}
}


void Fenetre::activerMenus    (int dimension)
{
	affichageMenus (dimension, true);
}


void Fenetre::desactiverMenus (int dimension)
{
	affichageMenus (dimension, false);
}


void Fenetre::affichageMenus (int dimension, bool afficher)
{
	/* toolbar */	
	barre_menu->Enable(afficher);
	
	/* menu Fichier */
	menuFichier->Enable(ID_MENU_EXPORT_NUAGE,  afficher);
	menuFichier->Enable(wxID_SAVE,             afficher);
	
	/* menu 2d */
	for (int i=ID_TOOL_SEUILLAGE_2D; i<=ID_TOOL_CONTOUR_2D; i++)
		menu2d->Enable(i,                      afficher);
	
	menu2d->Enable(ID_TOOL_HISTOGRAMME,        afficher);
	menu2d->Enable(ID_TOOL_DEFAULT_2D,         afficher);
	
	/* menu 3d */	
	for (int i=ID_TOOL_SEUILLAGE_3D; i<=ID_TOOL_CONTOUR_3D; i++)
		menu3d->Enable(i,                      afficher);
	
	menu3d->Enable(ID_TOOL_HISTOGRAMME,        afficher);
	menu3d->Enable(ID_TOOL_DEFAULT_3D,         afficher);	
	
	if (dimension==DIM_3D && afficher)
	{
		dimension = DIM_4D;
		afficher = false;
	}
	
	if (dimension==DIM_4D)
	{
		/* menu 4d */
		for (int i=ID_TOOL_SEUILLAGE_4D; i<=ID_TOOL_CONTOUR_4D; i++)
			menu4d->Enable(i,                  afficher);
		
		menu4d->Enable(ID_TOOL_HISTOGRAMME,    afficher);
		menu4d->Enable(ID_TOOL_DEFAULT_4D,     afficher);
	}
	
	/* menu Fenetre */
	menuFenetre->Enable(ID_TOOL_SEUILLAGE ,afficher);
	menuFenetre->Enable(ID_TOOL_HISTOGRAMME,afficher);
}


/*------------------------------------------------------------------------------[             cration des miniframes ]---------------*/


/* cre la miniframe seuillage */
void Fenetre::creerSeuillage (bool visible)
{
	unsigned int val, valMax;
	
	val = valMax = 65536;
	
	miniFrameSeuillage = new miniFrame(this, wxID_ANY, _T("seuillage"), wxPoint(100, 100), wxSize(350, 140), false);
	
	slide_seuilmin 		= new wxSlider 		(miniFrameSeuillage, wxID_ANY, 0, 0, valMax, wxDefaultPosition, wxSize( 200,20 ), wxSL_HORIZONTAL|wxNO_BORDER );
	slide_seuilmax		= new wxSlider 		(miniFrameSeuillage, wxID_ANY, valMax, 0, valMax, wxDefaultPosition, wxSize( 200,20 ), wxSL_HORIZONTAL|wxNO_BORDER );
	seuil_text 			= new wxStaticText	(miniFrameSeuillage, wxID_ANY, wxT("salut :)"), wxDefaultPosition, wxSize(300,20), wxSL_HORIZONTAL|wxNO_BORDER );
	bouton_seuiller		= new wxButton		(miniFrameSeuillage, wxID_ANY, wxT("Seuiller"), wxDefaultPosition, wxSize(50,20),wxBU_EXACTFIT);
	bouton_binariser	= new wxButton		(miniFrameSeuillage, ID_TOOL_BINARISER, wxT("Binariser"), wxDefaultPosition, wxSize(50,20));
	
	val = slide_seuilmin->GetValue();
	spinSeuilMin = new wxSpinCtrl(miniFrameSeuillage, wxID_ANY, wxString::Format(_T("%d"), val), wxDefaultPosition, wxSize(100,20), wxSP_VERTICAL|wxNO_BORDER, 0, valMax, val);
	
	val = slide_seuilmax->GetValue();
	spinSeuilMax = new wxSpinCtrl(miniFrameSeuillage, wxID_ANY, wxString::Format(_T("%d"), val), wxDefaultPosition, wxSize(100,20), wxSP_VERTICAL|wxNO_BORDER, 0, valMax, val);
	
	
	spinSeuilMin->Connect		( wxEVT_COMMAND_SPINCTRL_UPDATED, 	wxSpinEventHandler	 	(Fenetre::OnSpinSeuilMin), NULL, this );
	spinSeuilMax->Connect		( wxEVT_COMMAND_SPINCTRL_UPDATED, 	wxSpinEventHandler	 	(Fenetre::OnSpinSeuilMax), NULL, this );
	slide_seuilmin->Connect		( wxEVT_SCROLL_THUMBTRACK, 			wxScrollEventHandler 	(Fenetre::OnSlideMinMove), NULL, this );
	slide_seuilmax->Connect		( wxEVT_SCROLL_THUMBTRACK,			wxScrollEventHandler 	(Fenetre::OnSlideMaxMove), NULL, this );
	bouton_seuiller->Connect	( wxEVT_COMMAND_BUTTON_CLICKED,		wxCommandEventHandler	(Fenetre::OnSeuiller),	   NULL, this );
	bouton_binariser->Connect	( wxEVT_COMMAND_BUTTON_CLICKED,		wxCommandEventHandler	(Fenetre::OnLancerThread), NULL, this );
	
	
	miniFrameSeuillage->auiManager.AddPane(slide_seuilmin, wxAuiPaneInfo().Center().Position(1).CaptionVisible(false).BestSize(200,30));
    miniFrameSeuillage->auiManager.AddPane(spinSeuilMin, wxAuiPaneInfo().Right().Position(1).CaptionVisible(false).BestSize(100,30));
	miniFrameSeuillage->auiManager.AddPane(slide_seuilmax, wxAuiPaneInfo().Center().Position(2).CaptionVisible(false).BestSize(200,30));
    miniFrameSeuillage->auiManager.AddPane(spinSeuilMax, wxAuiPaneInfo().Right().Position(2).CaptionVisible(false).BestSize(100,30));
	miniFrameSeuillage->auiManager.AddPane(seuil_text, wxAuiPaneInfo().Bottom().Row(1).CaptionVisible(false).MinSize(350,20));
	miniFrameSeuillage->auiManager.AddPane(bouton_seuiller, wxAuiPaneInfo().Bottom().CaptionVisible(false));
	miniFrameSeuillage->auiManager.AddPane(bouton_binariser, wxAuiPaneInfo().Bottom().CaptionVisible(false));
	
    miniFrameSeuillage->auiManager.Update();
	miseAJour(MAJ_SEUIL);
	
	miniFrameSeuillage->Show(visible);
	Show(true);
}


/* cre la miniframe histogramme */
void Fenetre::creerHistogramme (bool visible)
{
	miniFrameHistogramme = new miniFrame(this, wxID_ANY, _T("histogramme"), wxPoint(100, 250), wxSize(350, 140), true);
	
	histo 		= new affHisto (miniFrameHistogramme, this, wxSize(340, 120));
	miniFrameHistogramme->auiManager.AddPane(histo, wxAuiPaneInfo().Center().CaptionVisible(false));
	
    miniFrameHistogramme->auiManager.Update();	
	miniFrameHistogramme->Show(visible);
	Show(true);
}


/* cre la miniframe script */
void Fenetre::creerScript (bool visible)
{
	miniFrameScript = new miniFrame(this, wxID_ANY, _T("script"), wxPoint(100, 500), wxSize(350, 140), true);
	
	wxBitmapButton *bouton_charger     = new wxBitmapButton (miniFrameScript, ID_MENU_LOADSCRIPT, wxBITMAP(ouvrir_script),      wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
	wxBitmapButton *bouton_executer    = new wxBitmapButton (miniFrameScript, ID_MENU_EXECSCRIPT, wxBITMAP(executer_script),    wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
	wxBitmapButton *bouton_enregistrer = new wxBitmapButton (miniFrameScript, ID_MENU_SAVESCRIPT, wxBITMAP(enregistrer_script), wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
	miniscript = new wxTextCtrl(miniFrameScript, wxID_ANY, _T(""), wxDefaultPosition, wxSize(340, 120), wxNO_BORDER | wxTE_MULTILINE);
	
	miniFrameScript->auiManager.AddPane(bouton_enregistrer, wxAuiPaneInfo().Top().CaptionVisible(false));
	miniFrameScript->auiManager.AddPane(bouton_executer, wxAuiPaneInfo().Top().CaptionVisible(false));
	miniFrameScript->auiManager.AddPane(bouton_charger, wxAuiPaneInfo().Top().CaptionVisible(false));
	miniFrameScript->auiManager.AddPane(miniscript, wxAuiPaneInfo().Center().CaptionVisible(false));
	
	bouton_charger->Connect     (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (Fenetre::OnMenuScript)       , NULL, this );
	bouton_executer->Connect    (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (Fenetre::OnMenuScript)       , NULL, this );
	bouton_enregistrer->Connect (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (Fenetre::OnMenuScript)       , NULL, this );
	
    miniFrameScript->auiManager.Update();	
	miniFrameScript->Show(visible);
	Show(true);
}
