#include "main.h"

#include <math.h>


bool MODE_VERBOSE;

/*
 * Point d'entree du programme
 */
IMPLEMENT_APP(Application)


void Application::usage()
{
	cerr << "Erreur dans les arguments." << std::endl;
	cerr << "Utilisation : \t" << string(((wxString)argv[0]).mb_str(wxConvLibc)) << " [-v] [nom du fichier script]" << std::endl;
}


bool Application::OnInit()
{
	string fichierScript;
	MODE_VERBOSE = false;
	fichierScript = "";
	
	if (argc > 1)
	{
		string tmp;
		
		for (int i=1; i!=argc; i++)
		{
			tmp = string(((wxString)argv[i]).mb_str(wxConvLibc));
			if (tmp == "-v")
				MODE_VERBOSE = true;
			else if (fichierScript == "")
				fichierScript = tmp;
			else
			{
				usage();
				exit(-1);
			}
		}
	}
	
	if (fichierScript != "")
	{
		sequence seq;
		script sc(fichierScript, &seq);
		sc.traiter();
		exit(0);
	}
	else
	{
		/* creation de la fenetre puis affichage */
		frame = new Fenetre(_T("seg3D"), wxPoint(150, 150), wxSize(800, 600));
		wxInitAllImageHandlers();
		
		SetTopWindow(frame);
		frame->Show(true);
	}
	
	return true;
}
