#include "loading.h"
#include "mainframe.h"


loadingVolume::loadingVolume (Fenetre *f, wxWindow* parent, int id, wxString title, wxPoint pos, wxSize size, int style)
	: wxDialog(parent, id, title, pos, size, style)
{
	frame = f;
	indice = -1;
	SetSizeHints (wxDefaultSize, wxDefaultSize);
	
	wxStaticBoxSizer* label;
	label = new wxStaticBoxSizer (new wxStaticBox (this, -1, wxT("Chargement d'un volume")), wxVERTICAL);
	
	listeFichier = new wxListBox (this, wxID_ANY, wxDefaultPosition, wxSize( 300,300 ), 0, NULL, 0); 
	label->Add (listeFichier, 0, wxALL, 5);
	
	wxBoxSizer* sizerBouton;
	sizerBouton = new wxBoxSizer (wxHORIZONTAL);
	
	bouton_ok = new wxButton (this, wxID_ANY, wxT("Charger"), wxDefaultPosition, wxDefaultSize, 0);
	sizerBouton->Add (bouton_ok, 0, wxALIGN_CENTER|wxALL, 5);
	
	bouton_annuler = new wxButton (this, wxID_ANY, wxT("Annuler"), wxDefaultPosition, wxDefaultSize, 0);
	sizerBouton->Add (bouton_annuler, 0, wxALIGN_CENTER|wxALL, 5);
	
	label->Add (sizerBouton, 1, wxALIGN_CENTER|wxALL, 5);	
	SetSizer (label);
	Layout();
	
	
	
	listeFichier->Connect   (wxEVT_COMMAND_LISTBOX_DOUBLECLICKED, wxCommandEventHandler (loadingVolume::ok)     , NULL, this );
	bouton_ok->Connect      (wxEVT_COMMAND_BUTTON_CLICKED,        wxCommandEventHandler (loadingVolume::ok)     , NULL, this );
	bouton_annuler->Connect (wxEVT_COMMAND_BUTTON_CLICKED,        wxCommandEventHandler (loadingVolume::annuler), NULL, this );
}


void loadingVolume::setMax (string nomFichier, int max)
{
	listeFichier->Clear();
	
	for (int i=1; i<=max; i++)
	{
		wxString tmp(nomFichier.c_str(), wxConvUTF8);
		tmp += wxString::Format(_T("%d"), i);
		listeFichier->AppendAndEnsureVisible(tmp);
	}
	listeFichier->Select(0);
}


void loadingVolume::ok (wxCommandEvent &WXUNUSED(event))
{
	indice = listeFichier->GetSelection() + 1;
	if (indice == wxNOT_FOUND)
		indice = -1;
	Close();
}


void loadingVolume::annuler (wxCommandEvent &WXUNUSED(event))
{
	indice = -1;
    Close();
}
