#ifndef FRAME2D_H
#define FRAME2D_H


/* includes wxWidget */
#include <wx/wx.h>
#include <wx/glcanvas.h>
#include <wx/gauge.h>
#include <wx/thread.h>
#include <wx/treectrl.h>
#include <wx/aui/aui.h>
#include <wx/wxprec.h>
#include <wx/spinctrl.h>
#include <wx/control.h>


/* includes programme */
#include "panelOpenGL2d.h"
#include "panelOpenGL3d.h"
	

#define AFFICHAGE_IMAGE		0
#define AFFICHAGE_OBJ		1


class Fenetre;


class frame2d : public wxControl
{
	private:
		int					 affichage;
		Fenetre 			*frame;
		wxAuiManager		 auiManager;
		panelOpenGL2d 		*opengl;
		panelOpenGL3d 		*openglObj;
	
	public:
		wxSlider 			*slide_coupe;
		
				frame2d 			(Fenetre *parent, wxWindowID id = wxID_ANY, const wxPoint& pos = wxDefaultPosition, const wxSize& size = wxDefaultSize);
		void	etat 				(bool actif);
		void 	actif 				();
		void 	nonActif			();
		int 	getHauteurCoupe 	();
		void	chargerObj			(string nomFichier);
		void	setAffichageObj 	();
		void	setAffichageImg 	();
		void	miseAJourVue		();

	private:
		void 	OnPaint 			(wxPaintEvent &event);
		void 	OnEraseBackground 	(wxEraseEvent &event);
		void	OnSize 				(wxSizeEvent &event);
		void 	OnSlideMove 		(wxScrollEvent &event);
		
		DECLARE_EVENT_TABLE()
};


#endif
