#include "frame2d.h"
#include "mainframe.h"


BEGIN_EVENT_TABLE(frame2d, wxControl)
    EVT_PAINT(frame2d::OnPaint)
    EVT_SIZE(frame2d::OnSize)
    EVT_ERASE_BACKGROUND(frame2d::OnEraseBackground)
END_EVENT_TABLE()


frame2d::frame2d (Fenetre *parent, wxWindowID id, const wxPoint& pos, const wxSize& size)
	: wxControl(parent, id, pos, size, wxNO_BORDER)
{
	auiManager.SetManagedWindow(this);
	frame = parent;
	
	opengl		= new panelOpenGL2d(this, frame, wxDefaultSize);
	openglObj	= new panelOpenGL3d(this, frame, wxDefaultSize);
	slide_coupe = new wxSlider (this, wxID_ANY, 0, 0, 65536, wxDefaultPosition, wxDefaultSize, wxSL_VERTICAL|wxNO_BORDER|wxSL_INVERSE);
	
	slide_coupe->Connect	( wxEVT_SCROLL_THUMBTRACK, 			wxScrollEventHandler (frame2d::OnSlideMove), NULL, this );
	nonActif();
    auiManager.AddPane(slide_coupe, wxAuiPaneInfo().Right().CaptionVisible(false).MinSize(20,-1));
	
	setAffichageImg();
    auiManager.Update();
}


void frame2d::etat (bool actif)
{
	slide_coupe->Enable(actif);
}


void frame2d::actif ()
{
	etat(true);
}


void frame2d::nonActif ()
{
	etat(false);
}


int frame2d::getHauteurCoupe ()
{
	return opengl->hauteurCoupe;
}


void frame2d::OnPaint (wxPaintEvent& WXUNUSED(evt))
{
	auiManager.Update();
}


void frame2d::OnEraseBackground (wxEraseEvent& WXUNUSED(evt))
{
	// intentionally empty
}


void frame2d::OnSize (wxSizeEvent& WXUNUSED(evt))
{
	Refresh();
}


void frame2d::OnSlideMove (wxScrollEvent &event)
{
	opengl->hauteurCoupe = event.GetPosition();
	frame->miseAJour(INIT_SEUIL);
	frame->miseAJour(MAJ_HISTO);
	Refresh(true);
}


void frame2d::chargerObj (string nomFichier)
{
	setAffichageObj();
	miseAJourVue();
	openglObj->chargerObj(nomFichier);
}


void frame2d::setAffichageObj()
{
	affichage = AFFICHAGE_OBJ;
	miseAJourVue();
}


void frame2d::setAffichageImg()
{
	affichage = AFFICHAGE_IMAGE;
	miseAJourVue();
}


void frame2d::miseAJourVue()
{
	auiManager.DetachPane(opengl);
	auiManager.DetachPane(openglObj);
	
	if (affichage == AFFICHAGE_OBJ)
	{
		opengl->Hide();
		openglObj->Show();
		openglObj->Refresh();
		auiManager.AddPane(openglObj, wxAuiPaneInfo().Center().CaptionVisible(false));
	}
	else
	{
		opengl->Show();
		openglObj->Hide();
		opengl->Refresh();
		auiManager.AddPane(opengl, wxAuiPaneInfo().Center().CaptionVisible(false));
	}
	
	opengl->Raise();
	openglObj->Raise();
    auiManager.Update();
	Refresh();
}
