#include "elementStruct.h"

#include <wx/artprov.h>
#include "bitmaps/cercle.xpm"
#include "bitmaps/carre.xpm"
#include "bitmaps/trait_horizontal.xpm"
#include "bitmaps/trait_vertical.xpm"


elementStruct *elementStruct::instance = NULL;


elementStruct::elementStruct (wxWindow* parent, int id, wxString title, wxPoint pos, wxSize size, int style)
	: wxDialog (parent, id, title, pos, size, style)
{
	SetSizeHints (wxDefaultSize, wxDefaultSize);
	taille = TAILLEMAX;
	
	tabElement = new wxTextCtrl **[TAILLEMAX];
	element = new bool **[TAILLEMAX];
	for (int i=0; i!=TAILLEMAX; i++)
	{
		tabElement[i] = new wxTextCtrl *[TAILLEMAX];
		element[i] = new bool *[TAILLEMAX];
		for (int j=0; j!=TAILLEMAX; j++)
		{
			/* dclarations des cases de l'lment structurant */
			tabElement[i][j] = new wxTextCtrl (this, i*TAILLEMAX+j, wxEmptyString, wxDefaultPosition, wxSize( 20,20 ), 0);
			tabElement[i][j]->SetEditable(false);
			element[i][j] = new bool [TAILLEMAX];
			for (int k=0; k!=TAILLEMAX; k++)
				element[i][j][k] = false;
		}
	}	
	
	wxBoxSizer *mainSizer;
	mainSizer = new wxBoxSizer (wxVERTICAL);
		/************* partie haute ***************/
		wxBoxSizer *objectSizer;
		objectSizer = new wxBoxSizer (wxHORIZONTAL);
			/************* partie gauche ***************/
			wxStaticBoxSizer *grilleSizer;
			grilleSizer = new wxStaticBoxSizer (new wxStaticBox(this, -1, wxT("Element structurant")), wxVERTICAL);
				wxGridSizer *gridSizer;
				gridSizer = new wxGridSizer (TAILLEMAX, TAILLEMAX, 0, 0);
				/* ajout */
				for (int i=0; i!=TAILLEMAX; i++)
					for (int j=0; j!=TAILLEMAX; j++)
						gridSizer->Add (tabElement[i][j], 0, 0, 5);
			grilleSizer->Add (gridSizer, 1, wxALL|wxEXPAND, 15);
			
			
			/************* partie droite ***************/
			wxBoxSizer *infoSizer;
			infoSizer = new wxBoxSizer (wxVERTICAL);
			infoSizer->SetMinSize (wxSize(200, -1));
				/************* premier cadre ***************/
				wxStaticBoxSizer* tailleSizer;
				tailleSizer = new wxStaticBoxSizer (new wxStaticBox(this, -1, wxT("Dimension")), wxVERTICAL);
				/* dclaration */
				lbl_taille = new wxStaticText (this, wxID_ANY, wxT("Taille de la matrice : 11x11"), wxDefaultPosition, wxDefaultSize, 0);
				slider_taille = new wxSlider (this, wxID_ANY, 50, 3, 11, wxDefaultPosition, wxDefaultSize, wxSL_HORIZONTAL);
				/* ajout */
				tailleSizer->Add (lbl_taille, 0, wxALL, 5);
				tailleSizer->Add (slider_taille, 0, wxALL|wxEXPAND, 5);
				
				
				/************* second cadre ***************/
				wxStaticBoxSizer* extensionSizer;
				extensionSizer = new wxStaticBoxSizer (new wxStaticBox(this, -1, wxT("Extension 2D -> 3D")), wxVERTICAL);
				/* dclaration */
				radio_lineaire = new wxRadioButton (this, wxID_ANY, wxT("lineaire"), wxDefaultPosition, wxDefaultSize, 0);
				radio_spherique = new wxRadioButton (this, wxID_ANY, wxT("spherique"), wxDefaultPosition, wxDefaultSize, 0);
				/* ajout */
				extensionSizer->Add (radio_lineaire, 0, wxALL, 5);
				extensionSizer->Add (radio_spherique, 0, wxALL, 5);
				
				
				/************* troisime cadre ***************/
				wxStaticBoxSizer* formeSizer;
				formeSizer = new wxStaticBoxSizer (new wxStaticBox (this, -1, wxT("Formes predefinies")), wxVERTICAL);	
					wxGridSizer *alignementFormeSizer;
					alignementFormeSizer = new wxGridSizer (1, 4, 0, 0);					
					/* dclaration */
					bouton_cercle = new wxBitmapButton (this, CERCLE, wxBITMAP(cercle), wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
					bouton_carre = new wxBitmapButton (this, CARRE, wxBITMAP(carre), wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
					bouton_trait_horizontal = new wxBitmapButton (this, TRAITH, wxBITMAP(trait_horizontal), wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
					bouton_trait_vertical = new wxBitmapButton (this, TRAITV, wxBITMAP(trait_vertical), wxDefaultPosition, wxSize(40,40), wxBU_EXACTFIT);
					/* ajout */
					alignementFormeSizer->Add (bouton_cercle, 0, wxALL, 5);
					alignementFormeSizer->Add (bouton_carre, 0, wxALL, 5);
					alignementFormeSizer->Add (bouton_trait_horizontal, 0, wxALL, 5);
					alignementFormeSizer->Add (bouton_trait_vertical, 0, wxALL, 5);			
				formeSizer->Add (alignementFormeSizer, 1, wxALL|wxEXPAND, 5);	
			infoSizer->Add (tailleSizer, 1, wxALL|wxEXPAND, 5 );
			infoSizer->Add (extensionSizer, 1, wxALL|wxEXPAND, 5 );
			infoSizer->Add (formeSizer, 1, wxALL|wxEXPAND, 5 );
		objectSizer->Add (grilleSizer, 5, wxALL|wxEXPAND, 10);
		objectSizer->Add (infoSizer, 4, wxALL|wxEXPAND, 5);
		
		
		/************* partie basse ***************/
		wxBoxSizer *boutonSizer;
		boutonSizer = new wxBoxSizer (wxHORIZONTAL);
		boutonSizer->SetMinSize (wxSize(-1, 40));
		/* dclaration */
		bouton_ok = new wxButton (this, wxID_ANY, wxT("OK"), wxDefaultPosition, wxDefaultSize, 0);
		bouton_annuler = new wxButton (this, wxID_ANY, wxT("Annuler"), wxDefaultPosition, wxDefaultSize, 0);
		/* ajout */
		boutonSizer->Add (bouton_ok, 0, wxALIGN_CENTER|wxALL, 5);
		boutonSizer->Add (bouton_annuler, 0, wxALIGN_CENTER|wxALL, 5);
	mainSizer->Add (objectSizer, 1, wxALL|wxEXPAND, 5);
	mainSizer->Add (boutonSizer, 0, wxALIGN_CENTER, 5);
		
	SetSizer(mainSizer);
	Layout();
	
	
	/************* connexion listener ***************/
	bouton_ok->Connect                (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::ok)       , NULL, this );
	bouton_annuler->Connect           (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::annuler)  , NULL, this );
	slider_taille->Connect	          (wxEVT_SCROLL_THUMBTRACK, 	 wxScrollEventHandler  (elementStruct::slide)    , NULL, this );
	bouton_cercle->Connect            (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::forme)    , NULL, this );
	bouton_carre->Connect             (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::forme)    , NULL, this );
	bouton_trait_horizontal->Connect  (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::forme)    , NULL, this );
	bouton_trait_vertical->Connect    (wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler (elementStruct::forme)    , NULL, this );
	for (int i=0; i!=TAILLEMAX; i++)
		for (int j=0; j!=TAILLEMAX; j++)
			tabElement[i][j]->Connect (wxEVT_LEFT_UP,                wxCommandEventHandler (elementStruct::update)   , NULL, this );
	
	isCercle = true;
	wxScrollEvent sc(0,0,3,0);
	slide(sc);
	wxCommandEvent i(wxEVT_COMMAND_BUTTON_CLICKED, CERCLE);
	forme(i);
}


elementStruct::~elementStruct ()
{
	for (int i=0; i!=TAILLEMAX; i++)
	{
		for (int j=0; j!=TAILLEMAX; j++)
		{
			delete tabElement[i][j];
			delete [] element [i][j];
		}
		
		delete [] tabElement[i];
		delete [] element[i];
	}
	delete [] tabElement;
	delete [] element;
}


elementStruct *elementStruct::getInstance ()
{
	if (instance == NULL)
		instance = new elementStruct(NULL);
	
	return instance;
}


void elementStruct::creerFenetre (wxWindow *parent)
{
	if (instance == NULL)
		instance = new elementStruct(parent);
}


void elementStruct::destroy ()
{
	if (instance != NULL)
	{
		delete instance;
		instance = NULL;
	}
}


void elementStruct::ok (wxCommandEvent &WXUNUSED(event))
{
	Close();
}


void elementStruct::annuler (wxCommandEvent &WXUNUSED(event))
{
    Close();
}


void elementStruct::update (wxCommandEvent &event)
{
	int i,j;
	i = event.GetId() / TAILLEMAX;
	j = event.GetId() % TAILLEMAX;
	
	element[AFFICHAGE][i][j] = !element[AFFICHAGE][i][j];
	if (element[AFFICHAGE][i][j])
		tabElement[i][j]->SetBackgroundColour(*wxBLACK);
	else
		tabElement[i][j]->SetBackgroundColour(*wxWHITE);
}


void elementStruct::slide (wxScrollEvent &event)
{
	if ((event.GetPosition()%2) == 0)
		return;
	
	taille = event.GetPosition();
	int tmp = (TAILLEMAX - taille) / 2;
	lbl_taille->SetLabel(wxString::Format(_T("Taille de la matrice : %dx%d"), taille, taille));
	
	for (int i=0; i!=TAILLEMAX; i++)
	{
		for (int j=0; j!=TAILLEMAX; j++)
		{
			if ( (i<tmp || i>TAILLEMAX-tmp-1) || (j<tmp || j>TAILLEMAX-tmp-1) )
				tabElement[i][j]->Hide();
			else
				tabElement[i][j]->Show();
		}
	}
}


void elementStruct::forme (wxCommandEvent &event)
{
	int tmp = (TAILLEMAX - taille) / 2;
	for (int i=0; i<TAILLEMAX; i++)
	{
		for (int j=0; j<TAILLEMAX; j++)
		{
			if ( (i>=tmp && i<=TAILLEMAX-tmp-1) && (j>=tmp && j<=TAILLEMAX-tmp-1) )
			{
				int iMilieu = i - (TAILLEMAX-1)/2;
				int jMilieu = j - (TAILLEMAX-1)/2;
				bool test = false;
				
				if (event.GetId() == CERCLE)
				{
					double dist = iMilieu*iMilieu + jMilieu*jMilieu;
					double distMax = ((taille-1)/2)*((taille-1)/2);
					test = ( dist <= distMax );
				}
				else if (event.GetId() == CARRE)
				{
					test = true;
				}
				else if (event.GetId() == TRAITH)
				{
					if (taille == 3)
						test = (iMilieu == 0);
					else
						test = (abs(iMilieu) < 2);
				}
				else if (event.GetId() == TRAITV)
				{
					if (taille == 3)
						test = (jMilieu == 0);
					else
						test = (abs(jMilieu) < 2);
				}
				
				element[AFFICHAGE][i][j] = test;
			}
			else
				element[AFFICHAGE][i][j] = false;
			
			
			if (element[AFFICHAGE][i][j])
				tabElement[i][j]->SetBackgroundColour(*wxBLACK);
			else
				tabElement[i][j]->SetBackgroundColour(*wxWHITE);
		}
	}
	
	/* passage en 3d */
	for (int k=0; k<TAILLEMAX; k++)
		for (int i=0; i<TAILLEMAX; i++)
			for (int j=0; j<TAILLEMAX; j++)
				if (k != AFFICHAGE)
					element[k][i][j] = element[AFFICHAGE][i][j];
	
	/* si interpolation sphrique, alors on restreint  une boule */
	if (radio_spherique->GetValue())
	{	
		for (int k=0; k<TAILLEMAX; k++)
		{
			for (int i=0; i<TAILLEMAX; i++)
			{
				for (int j=0; j<TAILLEMAX; j++)
				{
					if (k != AFFICHAGE)
					{
						int iMilieu = i - (TAILLEMAX-1)/2;
						int jMilieu = j - (TAILLEMAX-1)/2;
						int kMilieu = k - (TAILLEMAX-1)/2;
						
						double dist = iMilieu*iMilieu + jMilieu*jMilieu + kMilieu*kMilieu;
						double distMax = ((taille-1)/2)*((taille-1)/2)*((taille-1)/2);
						element[k][i][j] = ( dist <= distMax );
					}
				}
			}
		}
	}
}


bool **elementStruct::getElement2d ()
{
	return element[AFFICHAGE];
}


bool ***elementStruct::getElement3d ()
{
	return element;
}


bool elementStruct::getValeur (int i, int j, int k, bool en3d)
{
	/* en 2d on fixe k */
	if (!en3d)
		k = AFFICHAGE;
	/* en 3d on calcule la position */
	else
	{
		k += AFFICHAGE;
		
		if (k < 0)
			k = -k;
		else if (k > TAILLEMAX)
			k -= TAILLEMAX;
	}
	
	/* on centre dans le tableau */
	j += AFFICHAGE;
	if (j < 0)
		j = -j;
	else if (j >= TAILLEMAX)
		j -= TAILLEMAX;
	
	/* on centre dans le tableau */
	i += AFFICHAGE;
	if (i < 0)
		i = -i;
	else if (i >= TAILLEMAX)
		i -= TAILLEMAX;
	
	
	return element[k][j][i];
}


int elementStruct::getTailleElement ()
{
	return taille;
}
